%term PRINTOP SYMBOL LSYMBOL DSYMBOL NUMBER PREG PPSW
%term DIVIDE DOTDOT FLTREG REG
%term BRKP GO CONT SS BREAKS CLEAR
%term SAVE RST COPY
%term CMD COMMENT
%term ARRAY PATTERN
%term IF MACRO ENTER EXIT
%term NE EQ LE GE AND OR
%term INC DEC
%term LEXERR
%term REDIR DO SYSTEM
%term ARGS XCTMACRO
%binary ','
%right '='
%left OR
%left AND
%left EQ NE
%left '<' LE '>' GE
%left '+' '-'
%right '~'
%left '*' DIVIDE
%left INDIR
%left '[' '.'
%{
#include "dcon.h"
#include <sys/types.h>
#include <sys/stat.h>

#define BUMPDOWN (PRINST ? (dotdot -= instlen) : (dot -= prtlen))
#define BUMPUP (PRINST ? (dotdot += instlen) : (dot += prtlen))
#define BUMPDOT (PRINST ? tnode(DOTDOT, 0, 0, 0) : &dotnode)
#define PRINTPSW printf("psw = %8x %8x\n", state.ps_ps, state.ps_pc);

static struct tnode dotnode { '.', 0, 0, 0 };
static int ifflg = 0;
int realpattern;
%}
%%
%{
BP *bpp;
%}
input:
	input req '\n'          ={ if ($2) doreq($2, 0); }
|	input '\n'		={ prtval(BUMPUP, 0); }
|	empty
;
req:
	exp prtop               ={ $$ = tnode(PRINTOP, $2, $1, 0); }
|	PRINTOP			={ $$ = tnode(PRINTOP, $1, &dotnode, 0); }
|	exp ',' exp prtop	={ $$ = tnode(',', $4, $1, $3); }
|	'+' exp prtop		={ $$ = tnode(PRINTOP, $3,
					tnode('+', 0, BUMPDOT, $2), 0); }
|	'-' exp prtop		={ $$ = tnode(PRINTOP, $3,
					tnode('-', 0, BUMPDOT, $2), 0); }
|	'-' prtop		={ $$ = tnode(PRINTOP, $2,
					tnode(DEC, 0, 0, 0), 0); }
|       id '=' exp              ={ $$ = tnode('=', NUMBER, $1, $3); }
|       SYMBOL '=' exp          ={ $$ = tnode('=', SYMBOL, $1, $3); }
|       LSYMBOL '=' exp         ={ $$ = tnode('=', LSYMBOL, $1, $3); }
|       DSYMBOL '=' exp         ={ $$ = tnode('=', DSYMBOL, $1, $3); }
|	REG '=' exp		={ $$ = tnode('=', REG, $1, $3); }
|	IF '(' exp ')' req	={ $$ = tnode(IF, 0, $3, $5); }
|	'?' prtop		={ $$ = tnode('?', $2, 0, 0); }
|	'*' prtop		={ $$ = tnode(PRINTOP, $2,
			                tnode(INDIR, 0, &dotnode, 0), 0); }
|	PREG prtop		={ $$ = tnode(PREG, $2, 0, 0); }
|       PPSW prtop              ={ $$ = tnode(PPSW, $2, 0, 0); }
|	BRKP exp mreq comment	={ $$ = tnode(BRKP, $4, $2, $3); }
|       BRKP exp comment        ={ $$ = tnode(BRKP, $3, $2, 0); }
|	GO			={ $$ = tnode(GO, $1, 0, 0); }
|	CONT exp		={ $$ = tnode(CONT, 0, $2, 0); }
|	CONT			={ $$ = tnode(CONT, 0, 0, 0); }
|	SS exp mreq		={ $$ = tnode(SS, 0, $2, $3); }
|	SS mreq			={ $$ = tnode(SS, 0, 0, $2); }
|	SS exp			={ $$ = tnode(SS, 0, $2, 0); }
|	SS			={ $$ = tnode(SS, 0, 0, 0); }
|       SAVE exp COMMENT        ={ $$ = tnode(SAVE, $3, $2, 0); }
|       SAVE exp                ={ $$ = tnode(SAVE, 0, $2, 0); }
|       SAVE                    ={ $$ = tnode(SAVE, 0, 0, 0); }
|       RST exp                 ={ $$ = tnode(RST, 0, $2, 0); }
|       RST                     ={ $$ = tnode(RST, 0, 0, 0); }
|       COPY                    ={ $$ = tnode(COPY, $1, 0, 0); }
|	BREAKS			={ $$ = tnode(BREAKS, 0, 0, 0); }
|	CLEAR exp		={ $$ = tnode(CLEAR, 0, $2, 0); }
|	CLEAR			={ $$ = tnode(CLEAR, 0, 0, 0); }
|	REDIR			={ $$ = tnode(REDIR, $1, 0, 0); }
|       DO                      ={ $$ = tnode(DO, $1, 0, 0); }
|	SYSTEM			={ $$ = tnode(SYSTEM, $1, 0, 0); }
|       MACRO                   { argsflag++; }
	      DSYMBOL args req  ={ if (argsflag) argsflag--; $$ = tnode(MACRO, $3, $4, $5); }
|       DSYMBOL args            ={ $$ = tnode(XCTMACRO, $1, $2, 0); }
|	mreq
|	error			={ synerr(); $$ = 0; }
|	error LEXERR		={ $$ = 0; }
|	LEXERR			={ $$ = 0; }
;
prtop:
	PRINTOP			={ $$ = $1; }
|	empty			={ $$ = 0; }
;
mreq:
	'{' reqlist '}'		={ $$ = $2; }
|	'{' reqlist ';' '}'	={ $$ = $2; }
;
args:
	'('                     { argsflag++; }
	arglist ')'             ={ argsflag--; $$ = $3; }
;
arglist:
	arglist ',' SYMBOL      ={ $$ = tnode(ARGS, 0, $3, $1); }
|       SYMBOL                  ={ $$ = tnode(ARGS, 0, $1, 0); }
;
comment:
	COMMENT
|	empty			={ $$ = 0; }
;
reqlist:
	reqlist ';' req		={ $$ = tnode(';', 0, $1, $3); }
|	req
;
exp:
	id
|	SYMBOL			={ $$ = tnode(SYMBOL, $1, 0, 0); }
|       LSYMBOL                 ={ $$ = tnode(LSYMBOL, $1, 0, 0); }
|       DSYMBOL                 ={ $$ = tnode(DSYMBOL, $1, 0, 0); }
|	REG			={ $$ = tnode(REG, $1, 0, 0); }
|	exp '+' exp		={ $$ = tnode('+', 0, $1, $3); }
|	exp '-' exp		={ $$ = tnode('-', 0, $1, $3); }
|	exp '*' exp		={ $$ = tnode('*', 0, $1, $3); }
|	exp DIVIDE exp		={ $$ = tnode(DIVIDE, 0, $1, $3); }
|	exp EQ exp		={ $$ = tnode(EQ, 0, $1, $3); }
|	exp NE exp		={ $$ = tnode(NE, 0, $1, $3); }
|	'~' exp			={ $$ = tnode('~', 0, $2, 0); }
|	exp '<' exp		={ $$ = tnode('<', 0, $1, $3); }
|	exp LE exp		={ $$ = tnode(LE, 0, $1, $3); }
|	exp '>' exp		={ $$ = tnode('>', 0, $1, $3); }
|	exp GE exp		={ $$ = tnode(GE, 0, $1, $3); }
|	exp AND exp		={ $$ = tnode(AND, 0, $1, $3); }
|	exp OR exp		={ $$ = tnode(OR, 0, $1, $3); }
|	exp '.' id		={ $$ = tnode('+', 0, $1, $3); }
|	exp '[' exp ']'		={ $$ = tnode('+', 0, $1, $3); }
|	'*' exp %prec INDIR	={ $$ = tnode(INDIR, 0, $2, 0); }
|	'(' exp ')'		={ $$ = $2; }
;
id:
	NUMBER			={ $$ = tnode(NUMBER, $1, 0, 0); }
|       PATTERN                 ={ $$ = tnode(PATTERN, $1, 0, 0); }
|	'.'			={ $$ = &dotnode; }
|	DOTDOT			={ $$ = tnode(DOTDOT, 0, 0, 0); }
|	'$'			={ $$ = tnode('$', 0, 0, 0); }
|	ENTER SYMBOL ')'	={ $$ = tnode(ENTER, $2, 0, 0); }
|       EXIT  SYMBOL ')'        ={ $$ = tnode(EXIT,  $2, 0, 0); }
;
empty	: ;
%%
yyerror(s) char *s; { }

/*
 * synerr - report a syntax error
 *	the basic error recovery is gobble tokens until a newline,
 *	assuming of course that the token being choked on (yychar) is not
 *	a newline.  The statements "yyclearin" and "yyerrok" are special
 *	YACC commands.  Basically, "yyclearin" says forget about the
 *	current input token, and "yyerrok" says parse as though no error
 *	had occurred.
 */

synerr(){

	argsflag = 0;
	error(0, "syntax error");
	if (yychar != '\n') {
		gobble();
		yyclearin;
		}
	yyerrok;
	}

/*
 * process the '=' operation of assignment, i.e. target = source
 * there are 3 cases
 *	(1) the target is a NUMBER which is the address where the source goes
 *	(2) the target is a SYMBOL, i.e. a symbol table pointer
 *	    there are 3 different types of symbols which must be handled
 *		a debugger symbol (beginning with '#')
 *		a symbol for a register variable
 *		anything else (has value of a memory address)
 *	(3) the target is explicitly a register (i.e. ;r10 = 0)
 */

assign(t1, v, t, savflag)
struct tnode *t1;
int v, t, savflag;{

	register SYM *s;
	register struct arrayelt *a;
	int i, temp;

	switch(t) {
		case SYMBOL:
			s = t1;
			t = map(symval(s));
			if (s->sclass == REGVAR) {
				state.ps_gpr[s->val] = v;
				return(v);
				}
			if (s->sclass == GLOBL) {
				addmod(v, symval(s));
				}
			poke(v, t);
			return(s->val);
		case DSYMBOL:
			s = t1;
			if ((s->type == ARRAY) && (dim >= 0)) {
				a = s->val;
				for (i=0; i<dim; i++)
					if (a->nexta)
					        a = a->nexta;
					else {
					        error(0,"array bound error");
					        dim = -1;
					        return(v);
					        }
				dim = -1;
				return(a->arrayval = v);
				}
			if ((s->type != ARRAY) && (dim == -1))
				return(s->val = v);
			error(0, "array type error");
			dim = -1;
			return(0);
		case LSYMBOL:
			s = t1;
			t = map(lsymval(s));
			if (s->sclass == REGVAR) {
				state.ps_gpr[s->val] = v;
				return(v);
				}
			if (s->sclass == GLOBL) {       /*shouldn't be  */
				addmod(v, lsymval(s));
				}
			poke(v, t);
			return(s->val);
		case NUMBER:
			t = map(temp=doreq(t1, savflag));
			addmod(v, temp);
			poke(v, t);
			return(v);
		case REG:
			t = t1;
			state.ps_gpr[t] = v;
			return(v);
		}
	}

struct tnode *tnode(o, v, l, r)
int o, v;
struct tnode *l, *r;{

	register struct tnode *p;

	if ((p = calloc(1, sizeof(struct tnode))) == NULL)
		error(1, "out of memory");
	p->t_op = o;
	p->t_val = v;
	p->t_left = l;
	p->t_right = r;
	return(p);
	}

/*
 * doreq - execute a request that is stored in a tree
 *	savflag is set if the caller does not want his tree discarded
 *	after use, e.g. bp_cmd must be retained until the bp is cleared
 */



doreq(p, savflag)
struct tnode *p;
int savflag;{

	extern char *Null;
	register int v;
	register struct tnode *t1, *t2;
	struct stat stbuf;
	int r, v1, v2;
	int i, addr, w, rc;
	int len, otype;
	int fild;
	struct optab *pop;
	BP *bpp;
	FILE *fd;
	int savfildes;
	int savloc;
	SYM *s;
	struct arrayelt *a;
	int numbytes;
	int base;

	v = p->t_val;
	t1 = p->t_left;
	t2 = p->t_right;
	r = 0;
	switch(p->t_op) {
		case PRINTOP:
			setpr(v);
			prtval(doreq(t1, savflag), 0);
			break;

		case ',':
			setpr(v);
			printlist(doreq(t1, savflag), doreq(t2, savflag));
			break;

		case '=':
			v2 = doreq(t2, savflag);
			r = assign(t1, v2, v, savflag);
			break;

	/*
	 * some fudging must be done here using "ifflg"
	 * because in an if-expression you want the value of
	 * a symbol, rather than the normal address
	 */
		case IF:
			ifflg++;
			v = doreq(t1, savflag);
			--ifflg;
			if (v) doreq(t2, savflag);
			break;

		case '?':
			setpr(v);
			printstack();
			break;

		case PREG:
			setpr(v);
			printregs();
			break;

		case PPSW:
			setpr(v);
			PRINTPSW
			break;

		case BRKP:
			bpp = qbp(doreq(t1, savflag));
			if (bpp != NULL) {
				bpp->bp_cmd = t2;
				if (v) bpp->bp_comment = v;
				}
			break;

		case GO:
			go(v);
			break;

		case CONT:
			if (t1) cont(doreq(t1, savflag));
			else cont(lastbp);
			break;

		case SS:
			if (t1) v = doreq(t1, savflag);
			else v = lastbp;
			if (ss(v) == 0) {
				printf("%6x ", dotdot);
				prinst(dotdot, 1);
				if ((bpp = bplook(dotdot)) != NULL) {
					printf("\t(break point");
					if (bpp->bp_comment != Null)
						printf(": %s", bpp->bp_comment);
					putchar(')');
					}
				putchar('\n');
				if (t2) doreq(t2, savflag);
				}
			lastbp = dotdot;
			break;

		case SAVE:
			if (t1) {
				getcmt(savloc=doreq(t1,savflag));
				save(savloc);
				}
			else {
				getcmt(ALL_LOCS);
				save(ALL_LOCS);
				}
			break;

		case RST:
			if (t1)
				rst(doreq(t1,savflag));
			else rst(ALL_LOCS);
			break;

		case COPY:
			savfildes = fildes;
			if (v == 0) error(0, "no input file specified");
			else {
				rc = stat(objname, &stbuf);
				if (rc < 0)
					error(0, "can't open %s",objname);
				fildes = creat(v, stbuf.st_mode);
				free(v);
				if (fildes == -1)
					error(0, "can't write %s", v);
				else {
					copyfile(savfildes);
					save(ALL_LOCS);
                                        }
				}
			fildes = savfildes;
			break;

		case BREAKS:
			dbrks();
			break;

		case CLEAR:
			if (t1) bpclear(doreq(t1, savflag));
			else bptail = NULL;
			break;

		case ';':
			doreq(t1, savflag);
			doreq(t2, savflag);
			break;

		case PATTERN:
			inpattern = 1;
			switch(v) {
				case 'f':  numbytes = 4;
				           base = 10;
				           break;
				case 'b':  numbytes = 1;
				           base = 2;
				           break;
				case 'h':  numbytes = 2;
				           base = 10;
				           break;
				case 'x':  numbytes = 1;
				           base = 16;
				           break;
				case 'c':  numbytes = 1;
				           base = 0;
				           break;
				case 'i':  numbytes = BPW;
				           base = 0;
				           break;
				default:   numbytes = 0;
				           base = 0;
				           error(0,"cannot match on this pattern type");
				           break;
				}
			prtlen = 0;
			if (!numbytes) break;
			addr = dot;
			realpattern = cnvrt(v, base);   /* c or i => pattern; */
			                                /* else base 10 int   */
			if (realpattern != -1)          /* if not error */
			                                /* while not match    */
			        while( !compare(v, addr, numbytes))
			                addr = addr + incr(addr,v,numbytes);
			r = addr;
			inpattern = 0;
			break;

		case NUMBER:
			r = v;
			break;

		case SYMBOL:
			r = symval(v);
			if (ifflg) r = peek(map(r));
			break;

		case DSYMBOL:
			r = symval(v);
			break;

		case LSYMBOL:
			r = lsymval(v);
			if (ifflg) r = peek(map(r));
			break;

		case ARGS:
			if (v) r = v;
			else error(0,"tried to execute zero-valued args");
			break;

		case MACRO:
			if ((s = lookup(v)) == NULL)
				error(0,"macro name not in sym tab");
			else  s->val = tnode(MACRO, 0, t1, t2);
					/* Value gets tree w/left subtr*/
					/* of arglist & rt subtr of req*/
			break;

		case XCTMACRO:
			/* v:DSYMBOL; t1:real args in a tnode;          */
			/* v->val->t1:dummy args; v->val->t2;tree to xct*/
                        if (v->val==0) {
                                error(0, "macro never defined");
                                break;
			}
                        /* change dummys to actuals in v->val->t_right */
                        expand(v->val->t_left, t1, v->val->t_right);
                        doreq(v->val->t_right, savflag);
			break;

	/*
	 * a little hanky-panky here, we "switch" the prtlen
	 * so registers look like everybody else
	 * this is a kludge but so is the 470!
	 */
		case REG:
			r = state.ps_gpr[v];
			savplen = prtlen;
			prtlen = 0;
			break;

		case ENTER:
			r = ((SYM *) v)->val + PROLOG;
			break;

		case EXIT:
			r = ((SYM *) v)->val + PROLOG;
			w = peek(map(r));
	
					/* search for bcr reg 14        */
			while(! ((w.opcode==BCR) && (w.r1==15) && (w.r2==14)) ) {
				switch(w.opcode) {
				    case BC:
				    	pop = brlookup(w.r1, BRANCH);
				    	break;
				    case BCR:
				    	pop = brlookup(w.r1, BRANCHR);
				    	break;
				    case SVC:
				    	len = BPHW;
				    	break;
				    default:
				    	if ((pop = oplookup(w.opcode)) == NULL)
				            if (w.sopcode > 0xff)
						 pop = oplookup(w.sopcode);
				    	break;
				    }
	
				if (pop == NULL)  instlen = BPHW;  /*not found */
				otype = pop->op_type;
				switch(otype) {
					case RR:
					case BRANCHR:
						len = BPHW;
						break;
					case BRANCH:
					case RX:
					case RS1:
					case RS2:
					case SI1:
					case SI2:
						len = BPW;
						break;
					case SS1:
					case SS2:
					case SS3:
						len = BPW + BPHW;
						break;
					}
				r = r + len;    /* incr. by instr. lg   */
				w = peek(map(r));
				}
	
			r = r - 4;              /* back above lm instr. */
			break;

		case '+':
		case '-':
		case '*':
		case DIVIDE:
		case EQ:
		case NE:
		case '~':
		case '<':
		case LE:
		case '>':
		case GE:
		case AND:
		case OR:
		case INDIR:
			r = calc(p->t_op, t1, t2, savflag);
			break;

		case DOTDOT:
			r = dotdot;
			break;

		case '$':
			r = fend-stacksize-offset;
			break;

	/*
	 * NB:  this case does a RETURN instead of a BREAK
	 * This is because we don't want to cfree(&dotnode).
	 */
		case '.':
			return(dot);

		case DEC:
			if (PRINST) r = dotdot -= instlen;
			else r = dot -= prtlen;
			break;

		case REDIR:
			if (v == 0) out = stdout;
			else {
				out = fopen(v, "w");
				cfree(v);
				if (out == NULL) {
					out = stdout;
					error(0, "can't write %s", v);
					}
				}
			break;

		case DO:
			if (v == 0) error(0, "no input file specified");
			else {
				fd = fopen(v, "r");
				cfree(v);
				if (fd == NULL)
					error(0, "can't read %s", v);
				else pushin(fd);
				}
			break;

		case SYSTEM:
			r = system(v);
			cfree(v);
			printf("!\n");
			break;

		default:
			error(1, "unknown request %d", p->t_op);
		}
	if (savflag == 0) cfree(p);
	return(r);
	}

calc(op, t1, t2, savflag)
int op;
struct tnode *t1, *t2;
int savflag;{

	register int v1, v2;

	v1 = doreq(t1, savflag);
	if (t2) v2 = doreq(t2, savflag);
	switch(op) {
		case '+':
			return(v1+v2);
		case '-':
			return(v1-v2);
		case '*':
			return(v1*v2);
		case DIVIDE:
			return(v1/v2);
		case EQ:
			return(v1 == v2);
		case NE:
			return(v1 != v2);
		case '~':
			return(!v1);
		case '<':
			return(v1 < v2);
		case LE:
			return(v1 <= v2);
		case '>':
			return(v1 > v2);
		case GE:
			return(v1 >= v2);
		case AND:
			return(v1 && v2);
		case OR:
			return(v1 || v2);
		case INDIR:
			return(peek(map(v1))&STACKTOP);
		default:
			error(1, "unknown op %d", op);
		}
	}

/*
 * symval - figure out the address associated with a symbol
 *	easy for globals, hocus pocus for locals
 * If you don't understand the C calling sequence,
 * this function will make little sense to you.
 */

symval(p)
SYM *p;{

	register SYM *s;
	register int *savereg, *lastfunc;
	SYM *funcsym;
	int r, *lastsreg;
	int i;
	struct arrayelt *ap;

	if (p->name[0] == '#') {
		savplen = prtlen;
		prtlen = 0;
		if ((p->type == ARRAY) && (dim >= 0)) {
			ap = p->val;
			for(i=0; i<dim; i++)
				if (ap->nexta)
				        ap = ap->nexta;
				else {
				        if (decl && (i+1 == dim))  /* handling  */
				                decl = 0;       /* declaration  */
				        else error(0,"array bound error");
				        dim = -1;
				        return(0);
				        }
			dim = -1;
			return(ap->arrayval);
			}
		if ((p->type != ARRAY) && (dim == -1))
		        return(p->val);
		error(0, "array type error");
		dim = -1;
		return(0);
		}
	if (!trace && p->sclass == GLOBL) return(p->val);
	if (trace) {
		lastsreg = 0;
		savereg = state.ps_gpr[12]&STACKTOP;
		lastfunc = state.ps_gpr[10];
		while (savereg != 0) {
			funcsym = valp[vlook(lastfunc, N_TEXT)];

			for (s = p; s != NULL; s = s->next) {
				if (s->func==funcsym && strcmp(p->name, s->name)==0)
					return(sval(s, savereg, lastsreg));
				}
			lastfunc = peek(map(savereg+10));
			lastsreg = savereg;
			savereg = peek(map(savereg+12))&STACKTOP;
			}
		}
	for (s = p; s != NULL; s = s->next)
		if (s->func==NULL && strcmp(s->name, p->name)==0)
			return(s->val);
	error(0, "%s not active", p->name);
	if (p->sclass == REGVAR) {
		savplen = prtlen;
		prtlen = 0;
		}
	return(p->val);
	}

/*
 * for local symbols whose function is specified
 */

lsymval(p)
SYM *p;{

	register SYM *s;
	register int *savereg, *lastfunc;
	SYM *funcsym;
	int r, *lastsreg;

	if (trace) {
		lastsreg = 0;
		savereg = state.ps_gpr[12]&STACKTOP;
		lastfunc = state.ps_gpr[10];
		while (savereg != 0) {
			funcsym = valp[vlook(lastfunc, N_TEXT)];

			for (s = p; s != NULL; s = s->next) {

	/* p->func, not s->func cuz don't vary func throughout the      */
	/*   chain but stay with func requested                         */

				if (p->func==funcsym && strcmp(p->name, s->name)==0) {
					return(sval(s, savereg, lastsreg));
					}
				}
			lastfunc = peek(map(savereg+10));
			lastsreg = savereg;
			savereg = peek(map(savereg+12))&STACKTOP;
			}
		}
	error(0, "%s not active", p->name);
	if (p->sclass == REGVAR) {
		savplen = prtlen;
		prtlen = 0;
		}
	return(p->val);
	}

/*
 * symval function was getting out of hand
 * this function returns the "address" associated with
 * a local variable
 *	Note that we fudge for register variables by silently
 *	changing prtlen to 0 (the 'a' print length).
 */

static sval(p, r, lastr)
register SYM *p;
register int *r, *lastr;{

	if (p->sclass == REGVAR) {
		if (lastr != 0) return(lastr+p->val);
		else {
			savplen = prtlen;
			prtlen = 0;
			return(state.ps_gpr[p->val]);
			}
		}
	else return((peek(map(r+13))&STACKTOP)+p->val);
	}



/*
 *  move down tree x looking for substitutable macro quantity
 */

expand(da, ra, x)
struct tnode *da, *ra, *x;
{
	switch(x->t_op) {
		case ENTER:
		case EXIT:
			subst(da, ra, &x->t_val);
			break;
		case SYMBOL:
			subst(da, ra, &x->t_val);
			break;
		case '=':
			subst(da, ra, &x->t_left);
			break;
		default:
			if (x->t_left  != NULL) expand(da,ra,x->t_left);
			if (x->t_right != NULL) expand(da,ra,x->t_right);
			if ((x->t_left == NULL) && (x->t_right == NULL))
			        error(0,"macros can't substitute for this op\n");
		}
}



/*
 *  replace dummy arg with real arg if dummy arg matches tree's symbol
 */

subst(da, ra, t)
struct tnode *da, *ra;
SYM **t;
{
	SYM *s;
	while (da->t_right != NULL)
		if (strcmp(da->t_left, (*t)->name)==0) {  /*match dummy?*/
			if ((s = lookup(ra->t_left)) == NULL) {
				error("real arg to macro is symbol not found");
				return;
				}
			*t = s;         /* replace dum char* w/SYM *    */
			}
		else {
			da = da->t_right;          /* move down arglist */
			ra = ra->t_right;          /* move down arglist */
		}
	/* is null => 1 more arg to check */
	if (strcmp(da->t_left, (*t)->name)==0) {          /*match dummy?*/
		if ((s = lookup(ra->t_left)) == NULL) {
			error("real arg to macro is symbol not found");
			return;
			}
		*t = s;
	        }

}



/*
 * compare:  pattern type, address to check, #bytes to compare at once
 *           compare vs. global 'realpattern': desired pattern to match
 *           return 1 for match, return 0 for not match
 */

compare(type, addr, numbytes)
char *type;
int addr;
int numbytes;
{
	int k;
	register w, x;
	register struct optab *pop;
	int sysp;
	int loopaddr;
	char *c;

	k = peek(map(addr));
	if (quitread) {                         /* peek into bad area   */
		quitread = 0;
		return (1);                     /* stop checking        */
		}
	switch(numbytes) {
		case 1:  k = k & 0377;
			 break;
		case 2:  k = k & 0177777;
			 break;
		case 4:  break;
		default: error(0,"can't recognize pattern with this number of bytes");
		}

	switch(type) {
		case 'f':
		case 'b':
		case 'h':
		case 'x':
	                if (k == realpattern) return(1);
		                else return(0);
	                break;
		case 'c':
	                c = realpattern;
	                loopaddr = addr;
			while (*c) {
				k = peek(map(loopaddr++));
				if (quitread) {    /* peek into bad area*/
					quitread = 0;
					return (1);     /* stop checking*/
					}
		                k = ((k >> 24) & 0377);
				if (!cmprunit(k,*c++)) return(0);
				}
	                return(1);
	                break;
		case 'i':
                        w = peek(map(addr));
			if (quitread) {            /* peek into bad area*/
				quitread = 0;
				return (1);             /* stop checking*/
				}
	                switch(x = w.opcode) {
	                        case BC:
	                                pop = brlookup(w.r1, BRANCH);
	                                if (pop == NULL) {
	                                        error(0, "pattern not found");
	                                        return(1); /*stop chekng*/
	                                        }
	                                return(!strcmp(realpattern,pop->op_name));
	                                break;
	                        case BCR:
	                                pop = brlookup(w.r1, BRANCHR);
	                                if (pop == NULL) {
	                                        error(0, "pattern not found");
	                                        return(1); /*stop chekng*/
	                                        }
	                                return(!strcmp(realpattern,pop->op_name));
	                                break;
	                        case SVC:
	                                x = (w.r1 << 4) | w.r2;
	                                sysp = syslookup(x);
	                                if (sysp == NULL) {
	                                        error(0, "pattern not found");
	                                        return(1); /*stop chekng*/
	                                        }
                                        if (sysp != -1)
                                                return(!strcmp(realpattern,sys[sysp].sys_name));
                                        else return(!strcmp(realpattern,x));
	                        default:
	                                if ((pop = oplookup(x)) == NULL)
	                                        if (w.sopcode > 0xff)
	                                                pop = oplookup(w.sopcode);
	                                if (pop == NULL) {
	                                        error(0, "pattern not found");
	                                        return(1); /*stop chekng*/
	                                        }
	                                return(!strcmp(realpattern,pop->op_name));
	                        }
		}

}



/*
 *  convert pattern to true value, depending on pattern type
 */

cnvrt(type, base)
char type;
int base;
{
	switch(type) {
		case 'f':
		case 'b':
		case 'h':
		case 'x':
			return(tobinary(&pattern, base));
			break;
		case 'c':
			return(pattern);
			break;
		case 'i':
			return(pattern);
			break;
		}

}



/*
 *  determine amount to increment address for next search
 */

incr(addr, type, numbytes)
int addr;
char type;
int numbytes;
{
	register w, x;
	register struct optab *pop;

	switch(type) {
		case 'f':
		case 'b':
		case 'h':
		case 'x':
		case 'c':
			return(numbytes);
			break;
		case 'i':
	                w = peek(map(addr));
	                switch(x = w.opcode) {
	                        case BC:
	                                pop = brlookup(w.r1, BRANCH);
	                                break;
	                        case BCR:
	                                pop = brlookup(w.r1, BRANCHR);
	                                break;
	                        case SVC:
	                                return(BPHW);
	                                break;
	                        default:
	                                if ((pop = oplookup(x)) == NULL)
	                                        if (w.sopcode > 0xff)
	                                                pop = oplookup(w.sopcode);
	                                break;
	                        }
			if (pop == NULL) return(BPHW);
			switch(pop->op_type) {
	                        case RX:
	                        case RS1:
	                        case RS2:
	                        case SI1:
	                        case SI2:
	                        case S:
	                        case BRANCH:
	                                return(BPW);
	                                break;
	                        case RR:
	                        case BRANCHR:
	                                return(BPHW);
	                                break;
	                        case SS1:
	                        case SS2:
	                        case SS3:
	                                return(BPHW+BPW);
	                                break;
	                        }
			break;
		}

}



/*
 *  compare single character unit of string
 */

cmprunit(addr, pat)
int addr;
char pat;
{

	if (pat == '?') return(1);
	if (addr == pat) return(1);
		else return(0);

}
