/*
 * Au to VM 3270 Pass-Through
 */

#include <signal.h>
#include <stdio.h>

main(argc, argv)
char **argv;
{
	if(argc >= 3) {
		if(argv[1][0] != '-' || argv[1][1] != 'e') {
			fprintf(stderr, "Usage: pvm [-e escape_aid] [complex]\n");
			exit(1);
		}
		escaid = aidlook(argv[2]);
		if(escaid == 0 || escaid == PA1 || escaid == PA2 || escaid == CLEAR) {
			fprintf(stderr, "Bad escape AID\n");
			exit(1);
		}
		argc -= 2;
		argv += 2;
	}
	if(argc > 1)
		$open pvm(argv[1]);
	else
		$open pvm("");
	signal(SIGINTR, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	$interact;
}
