#include <stdio.h>
#include <sys/param.h>
#include <sys/filsys.h>
#include <sys/ino.h>

char    usage[] = "Usage: %s filsys [blockno ...]\n";
char    buf[BSIZE];
extern  char    *cmdname;
struct  filsys  sblock;


main(argc, argv)
int     argc;
char    **argv;
{
	int     *fd;
	struct  dinode  ino;
	int     naddr[10];
	int     oaddr[10];
	int     n = 0;
	char    naddr3[40];
	char    oaddr3[40];
	int     i, j, bb;

	argc--;
	if (argc < 1) {
		fprintf(stderr, usage, cmdname);
		exit(1);
	}
	if ((fd = open(*++argv, 2)) == -1) {
		fprintf(stderr, "%s: unable to open %s\n", cmdname, *argv);
		exit(1);
	}
	/*
         *  Read in the super block
	 */
	seek(fd, 1*BSIZE, 0);
	read(fd, (char *) &sblock, sizeof(ino));
	/*
	 *  Read inode 1
	 */
	seek(fd, 2*BSIZE, 0);
	read(fd, (char *) &ino, sizeof(ino));
	if (argc == 1) {
		prbad(&ino);
		exit(0);
	} else while (--argc) {
		bb = atoi(*++argv);
		if (bb >= sblock.s_fsize) {
			fprintf(stderr, "%s: %d: block number too large\n", cmdname, bb);
		} else {
		        seek(fd, bb*BSIZE, 0);
                        if (read(fd, buf, BSIZE) != -1)
                                fprintf(stderr, "%s: block %d not bad\n", cmdname, bb);
                        else {
                                naddr[n] = bb;
                                n++;
			}
		}
	}
	n--;
	/*
         *  Convert exiting block addresses to integers
	 */
	l3tol(oaddr, (char *)ino.di_addr, 10);
	for (i = 0; i < 10; i++) {
		if (oaddr[i] == 0)
			break;
	}
	for (j = 0; j <= n && i < 10; i++, j++) {
		oaddr[i] = naddr[j];
	}
	if (j < n)
		fprintf(stderr, "%s: too many badblocks\n");
	/*
         *  Replace the new numbers in the inode structure and
	 *  write it to the disk
	 */
	ltol3(ino.di_addr, oaddr, 10);
	seek(fd, 2*BSIZE, 0);
	ino.di_mode = 0100000;   /* Allocate inode */
	write(fd, (char *) &ino, sizeof(ino));
	close(fd);
	sync();
}

prbad(ino)
struct  dinode  *ino;
{
	int     oaddr[10];
	int     i;

	l3tol(oaddr, (char *)ino->di_addr, 10);
	for (i = 0; i < 10 && oaddr[i] != 0; i++) {
		fprintf(stderr, "%d\n", oaddr[i]);
	}
}
