/*
 * check - check a disk for inconsistencies
 *	code taken from icheck, dcheck, ncheck, and clri
 */

#include <sys/param.h>
#include <sys/stat.h>
#include <sys/ino.h>
#include <sys/filsys.h>
#include "dskdefs.h"

#define BMAPSZ 2048
#define NDIRS 787
#define ADDR(p, i) ((int) (p->di_addr[(i)*3]<<16) + (p->di_addr[1+(i)*3]<<8) + (p->di_addr[2+(i)*3]))
#define ROOTINO 2
 
extern int errno;
int npass1(), npass2(), npass3();
static struct dinode inode[NINODE];
static struct dinode inobuf[NINODE];             /* for ncheck */
static struct filsys sblock;
static struct htab {
	int hino;
	int hpino;
	char hname[DIRSIZ];
} htab[NDIRS];
 
static int nifiles;
static int ino, nchino;
static int nhent = 10;
static int bmap[BMAPSZ];
static int (*pass[])() = { npass1, npass2, npass3 };
 
check()
{
	printf("%s:\n", dskp->dskname);
	sync();
	bread(1, &sblock, BLKSIZE);
	if (sblock.s_isize != dskp->isize) {
		printf("Isize is %d, should be %d\n", sblock.s_isize, dskp->isize);
		dskp->bogus = 1;
		return;
	}
	if (sblock.s_fsize != dskp->fsize) {
		printf("Fsize is %d, should be %d\n", sblock.s_fsize, dskp->fsize);
		dskp->bogus = 1;
		return;
	}
	nifiles = (sblock.s_isize - 2) * INOPB;
	icheck();
	dcheck();
	if (dskp->nbad > 0)
		printf("\t%d bad inode(s)\n", dskp->nbad);
	if (dskp->badfree)
		printf("\tbad freelist\n");
}

icheck()
{

	register int *ip, i, j;
 
	ino = 0;
	for (ip = bmap; ip < &bmap[BMAPSZ];)
	        *ip++ = 0;
	for(i=0; ino < nifiles; i += NINODE/INOPB) {
	        bread(i+2, inode, sizeof inode);
	        for(j=0; j<NINODE && ino<nifiles; j++) {
	                ino++;
	                ipass1(&inode[j]);
	        }
	}
	ino = 0;
	sync();
	bread(1, &sblock, BLKSIZE);
	while(i = ialloc()) {
	        if (ichk(i, "free"))
	                break;
	}
	j = 0;
	for (ip = bmap; ip < &bmap[BMAPSZ];) {
	        i = *ip++;
	        while (i) {
	                if (i < 0)
	                        j--;
	                i <<= 1;
	        }
	}
	j += sblock.s_fsize - sblock.s_isize;
	if (j)
		dskp->badfree =| MISSING;
}
 
static int buf1[BLKSIZEW], vbuf1[BLKSIZEW];
ipass1(aip)
struct inode *aip;
{
	register i, j, *ip;
 
	ip = aip;
	if (ip->di_mode == 0)
	        return;
	if ((ip->di_mode & S_IFCHR & S_IFBLK) != 0)
	        return;
	for(i = 0; i < 10; i++) {
	        if (ADDR(ip, i))
	                ichk(ADDR(ip, i), "data (small)");
	}
	if (ADDR(ip, 10)) {
                if (ichk(ADDR(ip, 10), "indirect"))
                        return;
                bread(ADDR(ip, 10), buf1, BLKSIZE);
                for(j=0; j < BLKSIZEW; j++)
	                if (buf1[j] != 0)
	                        ichk(buf1[j], "data (large)");
        }
	if (ADDR(ip, 11)) {
	        if (ichk(ADDR(ip, 11), "indirect"))
                        return;
                bread(ADDR(ip, 11), buf1, BLKSIZE);
                for(i = 0; i < BLKSIZEW; i++)
                        if (buf1[i] != 0) {
                                if (ichk(buf1[i], "2nd indirect"))
                                        continue;
                                bread(buf1[i], vbuf1, BLKSIZE);
                                for(j=0; j<BLKSIZEW; j++)
                                        if (vbuf1[j])
                                                ichk(vbuf1[j], "data (very large)");
                        }
	}
}
 
ichk(ab, s)
char *ab;
{
	register char *b;
	register int n, m;
 
	b = ab;
	if (b < sblock.s_isize || b >= sblock.s_fsize) {
		mkbadi(ino, BAD, 0, 0);
	        return(1);
	}
	m = 1 << (b&037);
	n = (b>>5) & 0777777777;
	if (bmap[n]&m) {
		if (strcmp(s, "free") == 0)
			dskp->badfree = 1;
		else mkbadi(ino, DUP, 0, 0);
	}
	bmap[n] =| m;
	return(0);
}
 
static int buf2[BLKSIZEW];
ialloc()
{
	register b, i;
 
	i = --sblock.s_nfree;
	if (i < 0 || i >= NICFREE) {
		dskp->badfree =| BAD;
	        return(0);
	}
	b = sblock.s_free[i];
	if (b == 0)
	        return(0);
	if (sblock.s_nfree <= 0) {
	        bread(b, buf2, BLKSIZE);
	        sblock.s_nfree = buf2[0];
	        for(i = 0; i < NICFREE; i++)
	                sblock.s_free[i] = buf2[i+1];
	}
	return(b);
}
 
bread(bno, buf, cnt)
int *buf;
{
	register *ip;
 
	seek(dfildes, bno * BLKSIZE, 0);
	if (read(dfildes, buf, cnt) != cnt) {
		bomb("read error %d on block %d", errno, bno);
	        for (ip = buf; ip < &buf[BLKSIZEW];)
	                *ip++ = 0;
	}
}
 
static int buf3[BLKSIZEW];
ifree(in)
{
	register i;
 
	if (sblock.s_nfree >= NICFREE) {
	        buf3[0] = sblock.s_nfree;
	        for(i=0; i<NICFREE; i++)
	                buf3[i+1] = sblock.s_free[i];
	        sblock.s_nfree = 0;
	        bwrite(in, buf3);
	}
	sblock.s_free[sblock.s_nfree++] = in;
}
 
bwrite(bno, buf)
{
 
	seek(dfildes, bno * BLKSIZE, 0);
	if (write(dfildes, buf, BLKSIZE) != BLKSIZE)
		bomb("write error %d on block %d", errno, bno);
}

makefree()
{
	register i;
 
	sblock.s_nfree = 0;
	sblock.s_ninode = 0;
	sblock.s_flock = 0;
	sblock.s_ilock = 0;
	sblock.s_fmod = 0;
	ifree(0);
	for(i=sblock.s_fsize-1; i>=sblock.s_isize; i--) {
	        if ((bmap[(i>>5)&0777777777] & (1<<(i&037)))==0)
	                ifree(i);
	}
	bwrite(1, &sblock);
	sync();
	return;
}
char    *ecount;
int     reqcore;


dcheck()
{
	register int i, j;

	ecount = calloc(1, nifiles + 1);
	for (i = 0; i < nifiles; i++)
		ecount[i] = 0;
	ino = 0;
	for (i = 0; ino < nifiles; i += NINODE/INOPB) {
		bread(i+2, inode, sizeof inode);
		for (j = 0; j < NINODE && ino < nifiles; j++) {
			ino++;
			dpass1(&inode[j]);
		}
	}
	ino = 0;
	for (i = 0; ino < nifiles; i += NINODE/INOPB) {
		bread(i+2, inode, sizeof inode);
		for (j = 0; j < NINODE && ino < nifiles; j++) {
			ino++;
			dpass2(&inode[j]);
		}
	}
	cfree(ecount);
}

dpass1(aip)
struct inode *aip;
{
	register int doff;
	register struct inode *ip;
	char *dp;
	int i, inum;

	ip = aip;
	i = ino;
	if (ip->di_mode == 0) return;
	if ((ip->di_mode & S_IFMT) != S_IFDIR) return;
	doff = 0;
	while (dp = dread(ip, doff)) {
		doff += DIRENTSZ;
		inum = (dp[0] << 8) | dp[1];
		if (inum == 0) continue;
		if (inum > nifiles) {
			mkbadi(i, BAD, ecount[i], ip->di_nlink);
			continue;
		}
		ecount[inum]++;
	}
}

dpass2(aip)
struct inode *aip;
{
	register struct inode *ip;
	register int i;

	ip = aip;
	i = ino;
	if (ip->di_mode == 0 && ecount[i] == 0) return;
	if (ip->di_nlink == ecount[i] && ip->di_nlink != 0) return;
	if (ino == 1 && ip->di_nlink == 0 && ecount[i] == 0) return;
/*
 * Possibly these could be salvaged, but it's hardly ever worth it.
 *
 *      if (ip->di_nlink > ecount[i] && ecount[i] == 0) {
 *              printf("Warning:  inode %d, entries %d, links %d\n",
 *                      i, ecount[i], ip->di_nlink);
 *              return;
 *              }
 */
	mkbadi(i, LINKS, ecount[i] & 0377, ip->di_nlink & 0377);
}

static int ibuf1[BLKSIZEW];
static char buf4[BLKSIZE];

dread(aip, aoff)
struct inode *aip;
int aoff;
{
	register int b, off;
	register struct inode *ip;
	static int flag; /* Tells whether indirect block has been read. */

	off = aoff;
	ip = aip;
	if ((off % BLKSIZE) == 0){
		if (off == 0177*BLKSIZE) {
			printf("Monstrous directory %d\n", ino);
			return(0);
		}
		if (off < BLKSIZE * 10) {
			flag = 0;
			if ((b = ADDR(ip, off/BLKSIZE)) == 0)
				return(0);
			bread(b, buf4, BLKSIZE);
		} else {
			if (flag == 0 && off == BLKSIZE * 10) {
				if (ADDR(ip, 10) == 0)
				        return(0);
				bread(ADDR(ip, 10), ibuf1, BLKSIZE);
				flag = 1;
			}
			if ((b = ibuf1[(off/BLKSIZE) & 0177]) == 0)
				return(0);
			bread(b, buf4, BLKSIZE);
		}
	}
	return(&buf4[off%BLKSIZE]);
}

/*
 * make a new entry for a bad inode in the info table
 */

mkbadi(inum, kind, ents, lnks) 
int inum, kind, ents, lnks;
{
	register int i;
	register IINFO *ip;
	register int *n;

	n = &(dskp->nbad);

	/*
	 * first check to see if the rotten i-node has already
	 * been reported on, if so don't generate another entry
	 */
	for (i = 0; i < *n; i++, ip++) {
		ip = dskp->badi[i];
		if (ip->ino == inum) {
			ip->state |= kind;
			ip->entries = ents;
			ip->links = lnks;
			return;
		}
	}

	printf("inode %d bad, state %s", inum, statestr(kind));
	if (*n >= BADMAX)
		bomb("Too many bad inodes on %s", dskp->dskname);
	ip = dskp->badi[*n] = calloc(1, sizeof(IINFO));
	ip->ino = inum;
	ip->state = kind;
	ip->entries = ents;
	ip->links = lnks;
	if (kind == LINKS)
		printf("(entries=%d, links=%d)", ents, lnks);
	if (kind != LINKS || ents != 0)
		ncheck(ip);
	putchar('\n');
	(*n)++;
}


ncheck(iinfp)
register IINFO *iinfp;
{
        register i, j, pno;

	nhent = 10;
        for (i=0; i<NDIRS; i++)
                htab[i].hino = 0;
        for (pno=0; pno<3; pno++) {
                nchino = 0;
                for (i=0; nchino<nifiles; i += NINODE/INOPB) {
                        bread(i+2, inobuf, sizeof inobuf);
                        for (j=0; j<NINODE && nchino<nifiles; j++) {
                                nchino++;
                                (*pass[pno])(&inobuf[j], iinfp);
                        }
                }
        }
}

npass1(ip, iinfp)
register struct inode *ip;
IINFO *iinfp;
{
        if (ip->di_mode==0 || (ip->di_mode&S_IFMT)!=S_IFDIR)
                return;
        lookup(nchino, 1);
}

npass2(ip, iinfp)
struct inode *ip;
IINFO *iinfp;
{
        register doff;
        register struct htab *hp;
        char *dp;
        int i, inum;

        if (ip->di_mode==0 || (ip->di_mode&S_IFMT)!=S_IFDIR)
                return;
        doff = 0;
        while (dp = dread(ip, doff)) {
                doff += DIRENTSZ;
                inum = (dp[0]<<8) | dp[1];
                if (inum==0)
                        continue;
                if ((hp = lookup(inum, 0)) == 0)
                        continue;
                if (dotname(dp))
                        continue;
                hp->hpino = nchino;
                for (i=0; i<DIRSIZ; i++)
                        hp->hname[i] = dp[i+2];
        }
}

npass3(ip, iinfp)
struct inode *ip;
register IINFO *iinfp;
{
        register doff;
        char *dp, *p, *q;
        int inum;
        register int *ilp;

        if (ip->di_mode==0 || (ip->di_mode&S_IFMT)!=S_IFDIR)
                return;
        doff = 0;
        while (dp = dread(ip, doff)) {
                doff += DIRENTSZ;
                inum = (dp[0]<<8) | dp[1];
                if (inum==0)
                        continue;
		if (inum == iinfp->ino) {
			if (iinfp->inames) {
				q = iinfp->inames;
				while (*q) q++;
				*q++ = 1;
				}
			else q = iinfp->inames = calloc(512, 1);
			p = pname(nchino, 0, q);
			sprintf(p, "/%.14s", &dp[2]);
			printf("\n\tfilename %s", q);
		}
        }
}

dotname(dp)
register char *dp;
{
        if (dp[2] == '.')
                if (dp[3] == 0 || dp[3] == '.' && dp[4] == 0)
                        return(1);
        return(0);
}

/*
 * pname - gather a pathname recursively
 *	dependent on maximum length of pathname (currently 14)
 */

pname(i, lev, p)
register int i, lev;
register char *p;
{
	register struct htab *hp;
	char *q;

	if (i == ROOTINO) {
		sprintf(p, dskp->mntname);
		return(p+strlen(dskp->mntname));
	}
	if ((hp = lookup(i, 0)) == 0)
		bomb("No parent: %d", i);
	if (lev > 20)
		bomb("Too many levels: %d", i);
	p = pname(hp->hpino, ++lev, p);
	sprintf(p, "/%.14s", hp->hname);
	q = hp->hname;
	while (*q && q < hp->hname+14) q++, p++;
	return(p+1);
}

lookup(i, ef)
{
        register struct htab *hp;

        for (hp = &htab[i%NDIRS]; hp->hino;) {
                if (hp->hino==i)
                        return(hp);
                if (++hp >= &htab[NDIRS])
                        hp = htab;
        }
        if (ef==0)
                return(0);
        if (++nhent >= NDIRS)
		bomb("out of memory -- increase NDIRS");
        hp->hino = i;
        return(hp);
}

static char buf5[BLKSIZE];

clear(ino)
register int ino;
{
	int block, offset;
	register char *p, *q;

	if (ino > sblock.s_isize*INOPB) {
		printf("inode %d doesn't exist\n", ino);
		return;
	}
	block = (ino-1+2*INOPB)/INOPB;
	offset = sizeof (struct dinode) * ((ino-1+2*INOPB) % INOPB);
	bread(block, buf5, BLKSIZE);
	p = buf5 + offset;
	q = p + sizeof (struct dinode);
	while (p < q) *p++ = 0;
	bwrite(block, buf5);
}

rebuild(bad, fixit)
register DISK *bad;
int fixit;
{
	register int *ip, i, j;

	printf("\t\ticheck -s %s\n", bad->dskname);
	if (fixit) {
		ino = 0;
		for (ip = bmap; ip < &bmap[BMAPSZ];)
			*ip++ = 0;
		for (i = 0; ino < nifiles; i += NINODE/INOPB) {
			bread(i+2, inode, sizeof inode);
			for (j = 0; j < NINODE && ino < nifiles; j++) {
				ino++;
				ipass1(&inode[j]);
				}
			}
		ino = 0;
		sync();
		freeze(bad->dskname);
		bread(1, &sblock, BLKSIZE);
		makefree();
		thaw(bad->dskname);
		}
	}

/*
 * pokelinks - change the link count in an inode
 */

static char buf6[BLKSIZE];

pokelinks(i, n, fixit)
register int i, n;
int fixit;{

	int block, offset;
	struct inode *ip;

	printf("\t\tpokelinks inode=%d,links=%d\n", i, n);
	if (!fixit) return;
	block = (i-1+2*INOPB)/INOPB;
	offset = sizeof (struct dinode) * ((i-1+2*INOPB) % INOPB);
	bread(block, buf6, BLKSIZE);
	ip = buf6 + offset;
	ip->di_nlink = n;
	bwrite(block, buf6);
	}
