#include <stdio.h>
#define getchar(fp) getc(fp)
#define    MAXLINE    1000


main()
{
	char *arglist[9];

	cmptst1();
	cmptst2();
	savetst1();
	datetst1();
	sortst6();
	datetst2();
	datetst3();
	arglist[0] = "3";
	arglist[1] = "argument_1";
	arglist[2] = "argument_2";
	echo1(3, arglist);
	arglist[0] = "3";
	arglist[1] = "argument_1";
	arglist[2] = "argument_2";
	echo2(3, arglist);
	arglist[0] = "3";
	arglist[1] = "argument_1";
	arglist[2] = "argument_2";
	echo3(3, arglist);
	arglist[0] = "2";
	arglist[1] = "he";
	patst2(2, arglist);
	arglist[0] = "4";
        arglist[1] = "-x";
	arglist[2] = "-n";
	arglist[3] = "he";
	patst3(4, arglist);
	arglist[0] = "6";
	arglist[1] = "sort the following lines\n";
	arglist[2] = "into alphabetical order\n";
	arglist[3] = "And make sure that the\n";
	arglist[4] = "sort results are correct.\n";
	arglist[5] = "\n";
        sortst7(6, arglist);
	arglist[0] = "9";
	arglist[1] = "-n\n";
	arglist[2] = "234\n";
	arglist[3] = "3\n";
	arglist[4] = "78\n";
	arglist[5] = "9\n";
	arglist[6] = "34\n";
	arglist[7] = "-23\n";
	arglist[8] = "\n";
        sortst7(9, arglist);
	gaptst();
	datetst4();
	datetst5();
	datetst6();
	keytst1();
	keytst2();
	freqtst1();
}

cmptst1()
{
        register result;
        register char t[MAXLINE];
        register char s[MAXLINE];
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM cmptst1()\n\n");

	fp = fopen("in8.c", "r");

        while(getline3(s, MAXLINE, fp) > 0) {
	        getline3(t, MAXLINE, fp);
	        result = strcmp1(s, t);
		if (result < 0)
		        printf("%s\n\t\tIS LESS THAN\n%s\n\n", s, t);
		else if (result == 0)
		        printf("%s\n\t\tIS THE SAME AS\n%s\n\n", s, t);
		else
		        printf("%s\n\t\tIS GREATER THAN\n%s\n\n", s, t);
        }

	fclose(fp);
}

strcmp1(s, t)     /* copy t to s - array version */
register char s[], t[];
{
	register i;

	i = 0;
	while (s[i] == t[i])
		if (s[i++] == '\0')
			return(0);
	return(s[i] - t[i]);
}

cmptst2()
{
        register result;
        register char t[MAXLINE];
        register char s[MAXLINE];
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM cmptst2()\n\n");

	fp = fopen("in8.c", "r");

        while(getline3(s, MAXLINE, fp) > 0) {
	        getline3(t, MAXLINE, fp);
	        result = strcmp2(s, t);
		if (result < 0)
		        printf("%s\n\t\tIS LESS THAN\n%s\n\n", s, t);
		else if (result == 0)
		        printf("%s\n\t\tIS THE SAME AS\n%s\n\n", s, t);
		else
		        printf("%s\n\t\tIS GREATER THAN\n%s\n\n", s, t);
        }

	fclose(fp);
}

strcmp2(s, t)     /* copy t to s - pointer version */
register char *s, *t;
{
	for ( ; *s == *t; s++, t++)
		if (*s == '\0')
			return(0);
	return(*s - *t);
}

savetst1()
{
        register char s[MAXLINE];
	register char *str;
	char *strsave1();
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM savetst1()\n\n");

	fp = fopen("in1.c", "r");

        while(getline3(s, MAXLINE, fp) > 0) {
		str = strsave1(s);
		printf("saved string = %s\n", str);
        }
}

char *strsave1(s)     /* save string s somewhere */
register char *s;
{
	register char *p;
	char *alloc1();

	if ((p = alloc1(strlen4(s) + 1)) != NULL)
		strcpy4(p, s);
	else
		printf("ALLOC OUT OF SPACE\n");
	return(p);
}

datetst1()
{
        register char flag[MAXLINE];
        register char year[MAXLINE];
        register char month[MAXLINE];
        register char day[MAXLINE];
	int mth, dy;
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM datetst1()\n\n");

	fp = fopen("in9.c", "r");

        while(getline3(flag, MAXLINE, fp) > 0) {
		squeeze1(flag, ' ');
		squeeze1(flag, '\n');
		if (strcmp1(flag, "year") == 0) {
		        getline3(year, MAXLINE, fp);
		        getline3(month, MAXLINE, fp);
		        getline3(day, MAXLINE, fp);
			printf("day of year = %d\n",
			day1_of_year(atoi4(year), atoi4(month), atoi4(day)));
		}
	        else if (strcmp1(flag, "month") == 0) {
		        getline3(year, MAXLINE, fp);
		        getline3(day, MAXLINE, fp);
			month1_day(atoi4(year), atoi4(day), &mth, &dy);
			printf("month = %d  day = %d\n", mth, dy);
	        }
	        else {
		printf("error - wrong flag\n");
		return;
	        }
        }

	fclose(fp);
}

static int day_tab1[2] [13] = {
      {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},
      {0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}
};

day1_of_year(year, month, day)   /* set day of year  */
register year, month, day;           /* from month & day */
{
	register int i, leap;

	leap = year%4 == 0 && year%100 != 0 || year%400 == 0;
	for (i = 1; i < month; i++)
		day += day_tab1[leap][i];
	return(day);
}

month1_day(year, yearday, pmonth, pday)   /* set month, day   */
register int year, yearday, *pmonth, *pday;       /* from day of year */
{
	register i, leap;

	leap = year%4 == 0 && year%100 != 0 || year%400 == 0;
	for (i = 1; yearday > day_tab1[leap][i]; i++)
		yearday -= day_tab1[leap][i];
	*pmonth = i;
	*pday = yearday;
}

getline3(s, lim, fp)
register char s[];
register lim;
FILE *fp;
{
        register c, i;

        for (i=0; i<lim-1 && (c=getchar(fp))!=EOF && c!='\n'; ++i)
                s[i] = c;
        if (c == '\n')
                s[i++] = c;
        s[i] = '\0';
        return(i);
}

#define   NULL        0
#define   ALLOCSIZE   1000

static char alloc1buf[ALLOCSIZE];
static char *allocp1 = alloc1buf;

char *alloc1(n)
register n;
{
        if (allocp1 + n <= alloc1buf + ALLOCSIZE) {   /* fits */
                allocp1 += n;
                return(allocp1 - n);  /* old p */
        }
        else {    /* not enough room */
		printf("ALLOC1 OUT OF SPACE\n");
                return(NULL);
	}
}

strlen4(s)
register char *s;
{
	register char *p = s;

	while (*p)
		p++;
	return(p-s);
}

strcpy4(s, t)     /* copy t to s - pointer version 3 */
register char *s, *t;
{
	while (*s++ = *t++)
		;
}

atoi4(s)
register char s[];
{
        register i, val, sign;

        for (i=0; s[i]==' ' || s[i]=='\n' || s[i]=='\t'; i++)
                ;
        sign = 1;
        if (s[i] == '+' || s[i] == '-')
                sign = (s[i++] == '+') ? 1 : -1;
        for (val = 0; s[i] >= '0' && s[i] <= '9'; i++)
                val = 10 * val + s[i] - '0';

        return(sign * val);
}

squeeze1(s, c)
register char s[];
register c;
{
        register i, j;

        for (i = j = 0; s[i] != '\0'; i++)
                if (s[i] != c)
                        s[j++] = s[i];
                s[j] = '\0';
}

#define    LINES  100

sortst6()   /* sort input lines */
{
        register char *lineptr[LINES];  /* pointers to text lines */
        register int nlines;    /* number of input lines read */

	printf("\n\nRESULTS FROM sortst6()\n\n");

        if ((nlines = read1lines(lineptr, LINES)) >= 0)  {
                sort6(lineptr, nlines);
                write1lines(lineptr, nlines);
        }
        else
                printf("input too big to sort\n");
}

#define   MAXLEN   100

read1lines(lineptr, maxlines)    /* read input lines */
register char *lineptr[];              /* for sorting      */
register maxlines;
{
        register char *p, line[MAXLEN];
        register len, nlines;
        char *alloc1();
	FILE *fp, *fopen();

	fp = fopen("in1.c", "r");

        nlines = 0;
        while ((len = getline3(line, MAXLEN, fp)) > 0)
                if (nlines >= maxlines)
                        return(-1);
                else if ((p = alloc1(len)) == NULL)
                        return(-1);
                else {
                        line[len-1] = '\0';   /* zap newline */
                        strcpy4(p, line);
                        lineptr[nlines++] = p;
                }
	fclose(fp);
        return(nlines);

}

write1lines(lineptr, nlines)    /* write output lines */
register char *lineptr[];
register nlines;
{
        while (--nlines >= 0)
                printf("%s\n", *lineptr++);
}

datetst2()
{
        register char flag[MAXLINE];
        register char year[MAXLINE];
        register char month[MAXLINE];
        register char day[MAXLINE];
	int mth, dy;
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM datetst2()\n\n");

	fp = fopen("in9.c", "r");

        while(getline3(flag, MAXLINE, fp) > 0) {
		squeeze1(flag, ' ');
		squeeze1(flag, '\n');
		if (strcmp2(flag, "year") == 0) {
		        getline3(year, MAXLINE, fp);
		        getline3(month, MAXLINE, fp);
		        getline3(day, MAXLINE, fp);
			printf("day of year = %d\n",
			day2_of_year(atoi4(year), atoi4(month), atoi4(day)));
		}
	        else if (strcmp2(flag, "month") == 0) {
		        getline3(year, MAXLINE, fp);
		        getline3(day, MAXLINE, fp);
			month2_day(atoi4(year), atoi4(day), &mth, &dy);
			printf("month = %d  day = %d\n", mth, dy);
	        }
	        else {
		printf("error - wrong flag\n");
		return;
	        }
        }

	fclose(fp);
}

static int day_tab2[2] [13] = {
      {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},
      {0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}
};

day2_of_year(year, month, day)   /* set day of year  */
register year, month, day;           /* from month & day */
{
	register int i, leap;

	leap = year%4 == 0 && year%100 != 0 || year%400 == 0;
	for (i = 1; i < month; i++)
		day += day_tab2[leap][i];
	return(day);
}

month2_day(year, yearday, pmonth, pday)   /* set month, day   */
register year, yearday, *pmonth, *pday;       /* from day of year */
{
	register i, leap;

	leap = year%4 == 0 && year%100 != 0 || year%400 == 0;
	for (i = 1; yearday > day_tab2[leap][i]; i++)
		yearday -= day_tab2[leap][i];
	*pmonth = i;
	*pday = yearday;
}

sort6(v, n)    /* sort strings v[0] ... v[n-1]  */
register char *v[];
register n;
{
	register char *temp;
	register int gap, i, j;

	for(gap = n/2; gap > 0; gap /= 2)
		for (i = gap; i < n; i++)
			for (j = i-gap; j >= 0; j -= gap) {
				if (strcmp2(v[j], v[j+gap]) <= 0)
					break;
				temp = v[j];
				v[j] = v[j+gap];
				v[j+gap] = temp;
			}
}

datetst3()
{
        register char flag[MAXLINE];
        register char year[MAXLINE];
        register char month[MAXLINE];
        register char day[MAXLINE];
	int mth, dy;
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM datetst3()\n\n");

	fp = fopen("in9.c", "r");

        while(getline3(flag, MAXLINE, fp) > 0) {
		squeeze1(flag, ' ');
		squeeze1(flag, '\n');
		if (strcmp2(flag, "year") == 0) {
		        getline3(year, MAXLINE, fp);
		        getline3(month, MAXLINE, fp);
		        getline3(day, MAXLINE, fp);
			printf("day of year = %d\n",
			day3_of_year(atoi4(year), atoi4(month), atoi4(day)));
		}
	        else if (strcmp2(flag, "month") == 0) {
		        getline3(year, MAXLINE, fp);
		        getline3(day, MAXLINE, fp);
			month3_day(atoi4(year), atoi4(day), &mth, &dy);
			printf("month = %d  day = %d\n", mth, dy);
	        }
	        else {
		printf("error - wrong flag\n");
		return;
	        }
        }

	fclose(fp);
}

static int *day_tab3[2];
static ar1[] = {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
static ar2[] = {0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

day3_of_year(year, month, day)   /* set day of year from month & */
register year, month, day;           /* day - pointer version        */
{
	register int i, leap;

	day_tab3[0] = ar1;
	day_tab3[1] = ar2;

	leap = year%4 == 0 && year%100 != 0 || year%400 == 0;

	for (i = 0; i < month; i++, day_tab3[leap]++)
		day += *day_tab3[leap];
	return(day);
}

month3_day(year, yearday, pmonth, pday)   /* set month, day from day of */
register year, yearday, *pmonth, *pday;       /* year - pointer version     */
{
	register i, leap;

	day_tab3[0] = ar1;
	day_tab3[1] = ar2;

	leap = year%4 == 0 && year%100 != 0 || year%400 == 0;
	for (i = 0; yearday > *day_tab3[leap]; i++, day_tab3[leap]++)
		yearday -= *day_tab3[leap];
	*pmonth = i;
	*pday = yearday;
}

echo1(argc, argv)       /* echo arguments; 1st version */
register argc;
register char *argv[];
{
        int i;

	printf("\n\nRESULTS FROM echo1()\n\n");

        for (i = 1; i < argc; i++)
                printf("%s%c", argv[i], (i < argc-1) ? ' ' : '\n');
}

echo2(argc, argv)       /* echo arguments; 2nd version */
register argc;
register char *argv[];
{
	printf("\n\nRESULTS FROM echo2()\n\n");

	while (--argc > 0)
		printf("%s%c", *++argv, (argc > 1) ? ' ' : '\n');
}

echo3(argc, argv)       /* echo arguments; 3rd version */
register argc;
register char *argv[];
{
	printf("\n\nRESULTS FROM echo3()\n\n");

	while (--argc > 0)
		printf((argc > 0) ? "%s " : "%s\n", *++argv);
}

patst2(argc, argv)       /* find pattern from the first argument */
register argc;
register char *argv[];
{
	register char line[MAXLINE];
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM patst2()\n\n");

	fp = fopen("in10.c", "r");

	if (argc != 2)
		printf("Usage: find pattern\n");
	else
		while (getline3(line, MAXLINE, fp) > 0)
			if (index2(line, argv[1]) >= 0)
				printf("%s\n", line);

	fclose(fp);
}

patst3(argc, argv)       /* find pattern from the first argument */
register argc;
register char *argv[];
{
	register char line[MAXLINE], *s;
	int lineno = 0, except = 0, number = 0;
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM patst3()\n\n");

	fp = fopen("in10.c", "r");

	while (--argc > 0 && (*++argv)[0] == '-')
		for (s = argv[0]+1; *s != '\0'; s++)
			switch(*s) {
				case 'x':
					except = 1;
					break;
				case 'n':
					number = 1;
					break;
				default:
				  printf("find: illegal option %c\n", *s);
					argc = 0;
					break;
			}
	if (argc != 1)
		printf("Usage: find -x -n pattern\n");
	else
		while (getline3(line, MAXLINE, fp) > 0) {
			lineno++;
			if ((index2(line, *argv) >= 0) != except) {
				if (number)
					printf("%d: ", lineno);
				printf("%s\n", line);
			}
		}

	fclose(fp);
}

index2(s, t)
register char s[], t[];
{
        register i, j, k;

	for(i = 0; s[i] != '\0'; i++) {
	       for (j=i, k=0; t[k]!='\0' && s[j]==t[k]; j++, k++)
			;
		if (t[k] == '\0')
			return(i);
	}
	return(-1);
}

#define  MAXLINE    80
#define  LINES  15        /* max number of lines to be sorted */
int nlines;               /* number of input lines read */
char *lineptr[LINES];   /* pointers to text lines */

sortst7(argc, argv)      /* sort input lines */
register argc;
register char *argv[];
{
        int strcmp2(), numcmp7();  /* comparison functions */
        int swap7();               /* exchange function */
        register numeric = 0;      /* 1 if numeric sort */
	int idx = 0;

	printf("\n\nRESULTS FROM sortst7()\n\n");

	printf("UNSORTED LINES\n");
        if (argc>1 && argv[1][0] == '-' && argv[1][1] == 'n') {
                numeric = 1;
		idx = 1;
	}
        if ((nlines = read7lines(lineptr, LINES, &argv[idx])) >= 0) {
                write7lines(lineptr, nlines);
		printf("\n\nSORTED LINES\n");
                if (numeric)
                        sort7(lineptr, nlines, numcmp7, swap7);
                else
                        sort7(lineptr, nlines, strcmp2, swap7);
                write7lines(lineptr, nlines);
        }
        else
                printf("input too big to sort\n");
}

sort7(v, n, comp, exch)    /* sort strings v[0] ... v[n-1]  */
register char *v[];              /* into increasing order             */
register n;
int (*comp)(), (*exch)();
{
	register int gap, i, j;

	for(gap = n/2; gap > 0; gap /= 2)
		for (i = gap; i < n; i++)
			for (j = i-gap;j >= 0 & (j+gap) < n;j -= gap) {
				if ((*comp)(v[j], v[j+gap]) <= 0)
					break;
				(*exch)(v + j, v + (j+gap));
			}
}

numcmp7(s1, s2)   /* compare s1 and s2 numerically */
register char *s1, *s2;
{
	register v1, v2;

	v1 = atoi4(s1);
	v2 = atoi4(s2);
	if (v1 < v2)
		return(-1);
	else if (v1 > v2)
		return(1);
	else
		return(0);
}

swap7(px, py)    /* interchange *px and *py */
register char *px[], *py[];
{
	register char *temp;

	temp = *px;
	*px = *py;
	*py = temp;
}

read7lines(Lineptr, maxlines, addr)    /* read input lines */
register char *Lineptr[];                     /* for sorting      */
register int maxlines;
register char **addr;
{
	register char *p;
        register len, Nlines;
        char *alloc1(), line[MAXLEN];

        Nlines = 0;
        while ((len = getline7(line, MAXLEN, *++addr)) > 0)
                if (Nlines >= maxlines)
                        return(-1);
                else if ((p = alloc1(len)) == NULL)
                        return(-1);
                else {
                        line[len-1] = '\0';   /* zap newline */
                        strcpy4(p, line);
                        Lineptr[Nlines++] = p;
                }
        return(Nlines);
}

write7lines(Lineptr, Nlines)    /* write output lines */
register char *Lineptr[];
register int Nlines;
{
        while (--Nlines >= 0)
                printf("%s\n", *Lineptr++);
}

getline7(s, lim, str)
register char s[];
register int lim;
register char str[];
{
        register c, i;

        for (i=0; i<lim-1 && (c = str[i]) && c!='\n'; )
                s[i++] = c;
        if ((c == '\n') && i!=0)
                s[i++] = c;
        s[i] = '\0';
        return(i);
}

gaptst()
{
        register gap;

	printf("\n\nRESULTS FROM gaptst()\n\n");

        gap = 2;
	printf("gap = %d\n", gap);
        gap /= 2;
	printf("gap = %d\n", gap);
        gap /= 2;
	printf("gap = %d\n", gap);
}

struct date {
	int day;
	int month;
	int year;
	int yearday;
	char *mon_name;
};
struct date d = { 0, 0, 0, 0, "XXX" };
char *months[13] = { "XXX", "JAN", "FEB", "MAR", "APR", "MAY", "JUN",
                        "JUL", "AUG", "SEP", "OCT", "NOV", "DEC" };

datetst4()
{
        register char flag[MAXLINE];
        register char year[MAXLINE];
        register char month[MAXLINE];
        register char day[MAXLINE];
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM datetst4()\n\n");

	fp = fopen("in9.c", "r");

        while(getline3(flag, MAXLINE, fp) > 0) {
		squeeze1(flag, ' ');
		squeeze1(flag, '\n');
		if (strcmp2(flag, "year") == 0) {
		        getline3(year, MAXLINE, fp);
		        getline3(month, MAXLINE, fp);
		        getline3(day, MAXLINE, fp);
			d.year = atoi4(year);
			d.month = atoi4(month);
			d.day = atoi4(day);
			strcpy4(d.mon_name, months[d.month]);
			d.yearday = day4_of_year(d.year, d.month, d.day);
		}
	        else if (strcmp2(flag, "month") == 0) {
		        getline3(year, MAXLINE, fp);
		        getline3(day, MAXLINE, fp);
			d.year = atoi4(year);
			d.yearday = atoi4(day);
			month4_day(d.year, d.yearday, &d.month, &d.day);
			strcpy4(d.mon_name, months[d.month]);
	        }
	        else {
		printf("error - wrong flag\n");
		return;
	        }
      printf("day = %d\nmonth = %d\nyear = %d\nyearday = %d\nname = %s\n",
           d.day, d.month, d.year, d.yearday, d.mon_name);
        }

	fclose(fp);
}

static int *day4_tab[2];
static ar3[] = {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
static ar4[] = {0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

day4_of_year(year, month, day)   /* set day of year from month & */
register int year, month, day;           /* day - pointer version        */
{
	register int i, leap;

	day4_tab[0] = ar3;
	day4_tab[1] = ar4;

	leap = year%4 == 0 && year%100 != 0 || year%400 == 0;

	for (i = 0; i < month; i++, day4_tab[leap]++)
		day += *day4_tab[leap];
	return(day);
}

month4_day(year, yearday, pmonth, pday)   /* set month, day from day of */
register year, yearday, *pmonth, *pday;       /* year - pointer version     */
{
	register i, leap;

	day4_tab[0] = ar3;
	day4_tab[1] = ar4;

	leap = year%4 == 0 && year%100 != 0 || year%400 == 0;
	for (i = 0; yearday > *day4_tab[leap]; i++, day4_tab[leap]++)
		yearday -= *day4_tab[leap];
	*pmonth = i;
	*pday = yearday;
}

struct date5 {
	int day;
	int month;
	int year;
	int yearday;
	char *mon_name;
};

struct date5 d5 = { 0, 0, 0, 0, "XXX" };
char *months5[13] = { "XXX", "JAN", "FEB", "MAR", "APR", "MAY", "JUN",
                         "JUL", "AUG", "SEP", "OCT", "NOV", "DEC" };

datetst5()
{
        register char flag[MAXLINE];
        register char year[MAXLINE];
        register char month[MAXLINE];
        register char day[MAXLINE];
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM datetst5()\n\n");

	fp = fopen("in9.c", "r");

        while(getline3(flag, MAXLINE, fp) > 0) {
		squeeze1(flag, ' ');
		squeeze1(flag, '\n');
		if (strcmp2(flag, "year") == 0) {
		        getline3(year, MAXLINE, fp);
		        getline3(month, MAXLINE, fp);
		        getline3(day, MAXLINE, fp);
			d5.year = atoi4(year);
			d5.month = atoi4(month);
			d5.day = atoi4(day);
			strcpy4(d5.mon_name, months5[d5.month]);
			d5.yearday = day5_of_year(&d5);
		}
	        else if (strcmp2(flag, "month") == 0) {
		        getline3(year, MAXLINE, fp);
		        getline3(day, MAXLINE, fp);
			d5.year = atoi4(year);
			d5.yearday = atoi4(day);
			month5_day(&d5);
			strcpy4(d5.mon_name, months5[d5.month]);
	        }
	        else {
		printf("error - wrong flag\n");
		return;
	        }
  printf("day = %d\nmonth = %d\nyear = %d\nyearday = %d\nname = %s\n",
           d5.day, d5.month, d5.year, d5.yearday, d5.mon_name);
        }

	fclose(fp);
}

static int day5_tab[2][13] = {
	{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},
	{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}
};

day5_of_year(pd)           /* set day of year from month & */
register struct date5 *pd;          /* day - pointer version        */
{
	register int i, day, leap;

	day = pd->day;
	leap = pd->year % 4 == 0 && pd->year % 100 != 0
	          || pd->year % 400 == 0;

	for (i = 1; i < pd->month; i++)
		day += day5_tab[leap][i];
	return(day);
}

month5_day(pd)         /* set month, day from day of */
register struct date5 *pd;      /* year - pointer version     */
{
	register i, leap;

	leap = pd->year%4 == 0 && pd->year%100 != 0 || pd->year%400 == 0;

	pd->day = pd->yearday;
	for (i = 1; pd->day > day5_tab[leap][i]; i++)
		pd->day -= day5_tab[leap][i];
	pd->month = i;
}

struct date6 {
	int day;
	int month;
	int year;
	int yearday;
	char *mon_name;
};

struct date6 d6 = { 0, 0, 0, 0, "XXX" };
char *months6[13] = { "XXX", "JAN", "FEB", "MAR", "APR", "MAY", "JUN",
                         "JUL", "AUG", "SEP", "OCT", "NOV", "DEC" };


datetst6()
{
        register char flag[MAXLINE];
        register char year[MAXLINE];
        register char month[MAXLINE];
        register char day[MAXLINE];
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM datetst6()\n\n");

	fp = fopen("in9.c", "r");

        while(getline3(flag, MAXLINE, fp) > 0) {
		squeeze1(flag, ' ');
		squeeze1(flag, '\n');
		if (strcmp2(flag, "year") == 0) {
		        getline3(year, MAXLINE, fp);
		        getline3(month, MAXLINE, fp);
		        getline3(day, MAXLINE, fp);
			d6.year = atoi4(year);
			d6.month = atoi4(month);
			d6.day = atoi4(day);
			strcpy4(d6.mon_name, months6[d6.month]);
			d6.yearday = day6_of_year(&d6);
		}
	        else if (strcmp2(flag, "month") == 0) {
		        getline3(year, MAXLINE, fp);
		        getline3(day, MAXLINE, fp);
			d6.year = atoi4(year);
			d6.yearday = atoi4(day);
			month6_day(&d6);
			strcpy4(d6.mon_name, months6[d6.month]);
	        }
	        else {
		printf("error - wrong flag\n");
		return;
	        }
  printf("day = %d\nmonth = %d\nyear = %d\nyearday = %d\nname = %s\n",
           d6.day, d6.month, d6.year, d6.yearday, d6.mon_name);
        }

	fclose(fp);
}

static int day6_tab[2][13] = {
	{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},
	{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}
};

day6_of_year(pd)           /* set day of year from month & */
register struct date6 *pd;          /* day - pointer version        */
{
	register int i, day, leap;

	day = (*pd).day;
	leap = (*pd).year % 4 == 0 && pd->year % 100 != 0
	          || (*pd).year % 400 == 0;

	for (i = 1; i < (*pd).month; i++)
		day += day6_tab[leap][i];
	return(day);
}

month6_day(pd)         /* set month, day from day of */
register struct date6 *pd;      /* year - pointer version     */
{
	register i, leap;

	leap = (*pd).year%4 == 0 && pd->year%100 != 0 || pd->year%400 == 0;

	(*pd).day = pd->yearday;
	for (i = 1; (*pd).day > day6_tab[leap][i]; i++)
		(*pd).day -= day6_tab[leap][i];
	(*pd).month = i;
}

struct key1 {
        char *keyword;
        int keycount;
} keytab1[] = {
	"auto",0,
	"break",0,
	"case",0,
	"char",0,
	"continue",0,
	"default",0,
	"define",0,
	"do",0,
	"double",0,
	"else",0,
	"endif",0,
	"extern",0,
	"float",0,
	"for",0,
	"goto",0,
	"if",0,
	"ifdef",0,
	"ifndef",0,
	"include",0,
	"int",0,
	"long",0,
	"register",0,
	"return",0,
	"short",0,
	"sizeof",0,
	"static",0,
	"struct",0,
	"switch",0,
	"typedef",0,
	"undef",0,
	"union",0,
	"unsigned",0,
	"while",0
};

#define    MAXWORD  20
#define    NKEYS  (sizeof(keytab1) / sizeof(struct key1))
#define    LETTER   'a'
#define    DIGIT    '0'

keytst1()    /* count C keywords */
{
        register n, t;
        register char word[MAXWORD];
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM keytst1()\n\n");

	fp = fopen("in11.c", "r");

        while ((t = getword1(word, MAXWORD, fp)) != EOF)
                if (t == LETTER)
                        if ((n = binary1(word, keytab1, NKEYS)) >= 0)
                                keytab1[n].keycount++;
        for (n = 0; n < NKEYS; n++)
                if (keytab1[n].keycount > 0)
                        printf("%4d %s\n",
                               keytab1[n].keycount, keytab1[n].keyword);

	fclose(fp);
}

binary1(word, tab, n)   /* find word in tab[0] ... tab[n-1] */
register char *word;
register struct key1 tab[];
register int n;
{
        register low, high, mid, cond;

        low = 0;
        high = n - 1;
        while (low <= high) {
                mid = (low+high) / 2;
                if ((cond = strcmp2(word, tab[mid].keyword)) < 0)
	                high = mid - 1;
		else if (cond > 0)
			low = mid + 1;
                else
                        return(mid);
        }
        return(-1);
}

getword1(w, lim, fp)     /* get next word from input */
register char *w;
register int lim;
FILE *fp;
{
	register c, t;

        if (type1(c = *w++ = getch(fp)) != LETTER) {
		*w = '\0';
		return(c);
	}
	while (--lim > 0) {
		t = type1(c = *w++ = getch(fp));
		if (t != LETTER && t != DIGIT)  {
			ungetch(c);
			break;
		}
	}
	*(w-1) = '\0';
	return(LETTER);
}

type1(c)   /* return type of ASCII character */
register int c;
{
	if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')
		return(LETTER);
	else if (c >= '0' && c <= '9')
		return(DIGIT);
	else
		return(c);
}
#define  BUFSIZE   100

char buf[BUFSIZE];
int bufp = 0;

getch(fp)
FILE *fp;
{
	return((bufp > 0) ? buf[--bufp] : getchar(fp));
}

ungetch(c)
register int c;
{
	if (bufp > BUFSIZE)
		printf("ungetch: too many characters\n");
	else
		buf[bufp++] = c;
}

struct key2 {
        char *keyword;
        int keycount;
} keytab2[] = {
	"auto",0,
	"break",0,
	"case",0,
	"char",0,
	"continue",0,
	"default",0,
	"define",0,
	"do",0,
	"double",0,
	"else",0,
	"endif",0,
	"extern",0,
	"float",0,
	"for",0,
	"goto",0,
	"if",0,
	"ifdef",0,
	"ifndef",0,
	"include",0,
	"int",0,
	"long",0,
	"register",0,
	"return",0,
	"short",0,
	"sizeof",0,
	"static",0,
	"struct",0,
	"switch",0,
	"typedef",0,
	"undef",0,
	"union",0,
	"unsigned",0,
	"while",0
};

#define    NKEYS  (sizeof(keytab2) / sizeof(struct key2))

keytst2()    /* count C keywords */
{
        register char word[MAXWORD];
	register struct key2 *p;
        register t;
	struct key2 *binary2();
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM keytst2()\n\n");

	fp = fopen("in11.c", "r");

        while ((t = getword2(word, MAXWORD, fp)) != EOF)
                if (t == LETTER)
                        if ((p = binary2(word, keytab2, NKEYS)) != NULL)
                                p->keycount++;
        for (p = keytab2; p < keytab2 + NKEYS; p++)
                if (p->keycount > 0)
                        printf("%4d %s\n", p->keycount, p->keyword);

	fclose(fp);
}

struct key2 *binary2(word, tab, n)   /* find word */
                                    /* in tab[0] ... tab[n-1] */
register char *word;
register struct key2 tab[];
register int n;
{
	register struct key2 *low = &tab[0];
	register struct key2 *high = &tab[n-1];
	register struct key2 *mid;
        register cond;

        while (low <= high) {
                mid = low + (high-low) / 2;
                if ((cond = strcmp2(word, mid->keyword)) < 0)
	                high = mid - 1;
		else if (cond > 0)
			low = mid + 1;
                else
                        return(mid);
	}
        return(NULL);
}

getword2(w, lim, fp)     /* get next word from input */
register char *w;
register int lim;
FILE *fp;
{
	register c, t;

        if (type2(c = *w++ = getch(fp)) != LETTER) {
		*w = '\0';
		return(c);
	}
	while (--lim > 0) {
		t = type2(c = *w++ = getch(fp));
		if (t != LETTER && t != DIGIT)  {
			ungetch(c);
			break;
		}
	}
	*(w-1) = '\0';
	return(LETTER);
}

type2(c)   /* return type of ASCII character */
register int c;
{
	if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')
		return(LETTER);
	else if (c >= '0' && c <= '9')
		return(DIGIT);
	else
		return(c);
}

struct tnode {         /* the basic node */
        char *word;     /* points to the text */
        int count;      /* number of occurrences */
	struct tnode *left;    /* left child */
	struct tnode *right;   /* right child */
};

freqtst1()    /* word frequency count */
{
	register struct tnode *root;
	struct tnode *tree1();
	register char word[MAXWORD];
	register int t;
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM freqtst1()\n\n");

	fp = fopen("in11.c", "r");

	root = NULL;
	while ((t = getword2(word, MAXWORD, fp)) != EOF)
		if (t == LETTER)
			root = tree1(root, word);
	treeprint1(root);

	fclose(fp);
}

struct tnode *tree1(p, w)    /* install w at or below p */
register struct tnode *p;
register char *w;
{
	struct tnode *talloc1();
	char *strsave1();
	register cond;

	if (p == NULL)  {    /* a new word has arrived */
		p = talloc1();        /* make a new word */
		p->word = strsave1(w);
		p->count = 1;
		p->left = p->right = NULL;
	}
	else if ((cond = strcmp2(w, p->word)) == 0)
		p->count++;    /* repeated word */
	else if (cond < 0)  /* lower goes into left subtree */
		p->left = tree1(p->left, w);
	else     /* greater into right subtree */
		p->right = tree1(p->right, w);
	return(p);
}

treeprint1(p)    /* print tree p recursively */
register struct tnode *p;
{
	if (p != NULL)  {
		treeprint1(p->left);
		printf("%4d  %s\n", p->count, p->word);
		treeprint1(p->right);
	}
}

struct tnode *talloc1()
{
        char *alloc2();

        return((struct tnode *) alloc2(sizeof(struct tnode)));
}

#define   ALLOCSIZE   1500

static char alloc2buf[ALLOCSIZE];
static char *allocp2 = alloc2buf;

char *alloc2(n)
register int n;
{
        if (allocp2 + n <= alloc2buf + ALLOCSIZE) {   /* fits */
                allocp2 += n;
                return(allocp2 - n);  /* old p */
        }
        else {    /* not enough room */
		printf("ALLOC2 OUT OF SPACE\n");
                return(NULL);
	}
}

