/*
 * tunable variables
 */

#define NUSER   40              /* number of expected users */
#define NBUF    50              /* size of buffer cache */
#define NINODE  (10*NUSER)      /* number of in core inodes */
#define NFILE   (10*NUSER)      /* number of in core file structures */
#define NMOUNT  16              /* number of mountable file systems */
#define MAXMEM  256             /* max core per process - in pages */
#define	MAXUPRC	25		/* max processes per user */
#define SSIZE   1               /* initial stack size (pages) */
#define	NOFILE	20		/* max open files per process */
#define	CANBSIZ	256		/* max size of typewriter line */
#define	NCALL	20		/* max simultaneous time callouts */
#define NPROC   (6*NUSER)       /* max number of processes */
#define NTEXT   64              /* max number of pure texts */
#define NCLIST  (8*NUSER)       /* max total clist size */
#define HZ      1               /* Ticks/second of the clock */
#define TIMEZONE (8*60)         /* Minutes westward from Greenwich */
#define	DSTFLAG	1		/* Daylight Saving Time applies in this locality */
#define LOCALTOD 1              /* 1 if clock runs in local time */
#define MSGBUFS 2000            /* Characters saved from error messages */
#define NCARGS  4096            /* # characters in exec arglist */
#define NSIG    31              /* number of signals */
#define T_HIGH 0x7FFFFFFFFFFFFFFFL /* highest cpu timer value */
#define T_SLICE 0x0000000010000000L /* time slice for user pgm - 1/16 sec */
#define PAGSLOP 10              /* pages not available to fork and exec */

/*
 * priorities
 * probably should not be
 * altered too much
 */

#define	PSWP	0
#define	PINOD	10
#define	PRIBIO	20
#define	PZERO	25
#define	NZERO	20
#define	PPIPE	26
#define	PWAIT	30
#define	PSLEP	40
#define	PUSER	50

/*
 * fundamental constants of the implementation--
 * cannot be changed easily
 */

#define PSIZE   4096            /* size of a page (click) */
#define PMASK   0xFFF           /* PSIZE-1 */
#define PSHIFT  12              /* LOG2(PSIZE) */
#define	NBPW	sizeof(int)	/* number of bytes in an integer */
#define BSIZE   4096            /* size of secondary block (bytes) */
#define	NINDIR	(BSIZE/sizeof(daddr_t))
#define BMASK   07777           /* BSIZE-1 */
#define BSHIFT  12              /* LOG2(BSIZE) */
#define NMASK   01777           /* NINDIR-1 */
#define NSHIFT  10              /* LOG2(NINDIR) */
#define USIZE   1               /* size of user block (pages) */
#define	NULL	0
#define	CMASK	0		/* default mask for file creation */
#define	NODEV	(dev_t)(-1)
#define	ROOTINO	((ino_t)2)	/* i number of all roots */
#define	SUPERB	((daddr_t)1)	/* block number of the super block */
#define	DIRSIZ	14		/* max characters per directory */
#define NICINOD 200             /* number of superblock inodes */
#define NICFREE 900             /* number of superblock free blocks */
#define	INFSIZE	138		/* size of per-proc info for users */
#define CBSIZE  60              /* number of chars in a clist block */
#define CROUND  077             /* clist rounding: sizeof(int *) + CBSIZE - 1*/

/*
 * Some macros for units conversion
 */
/* Core clicks (pages) to segments(64K) and vice versa */
#define ctos(x) (((x)+15)/16)
#define stoc(x) ((x)*16)

/* Core clicks (pages) to disk blocks */
#define ctod(x) (x)

/* inumber to disk address */
#define itod(x) (daddr_t)((((unsigned)x+127)>>6))

/* inumber to disk offset */
#define itoo(x) (int)((x+127)&077)

/* clicks to bytes */
#define ctob(x) ((x)<<12)

/* bytes to clicks */
#define btoc(x) ((((unsigned)(x)+4095)>>12))

/* major part of a device */
#define	major(x)	(int)(((unsigned)x>>8))

/* minor part of a device */
#define	minor(x)	(int)(x&0377)

/* make a device number */
#define	makedev(x,y)	(dev_t)((x)<<8 | (y))

typedef int             daddr_t;
typedef char *		caddr_t;
typedef unsigned short  ino_t;
typedef int             time_t;
typedef int             label_t[14];     /* regs 2-15 */
typedef short           dev_t;
typedef int             off_t;
typedef long            cpu_t;          /* 370 CPU timer format */
typedef long            tod_t;          /* 370 TOD clock format */
