#define	_DDI_DKI	1
#define	_SYSV4		1

/*
 * This file exists to provide external-linkage versions of the normally
 * inline definitions for the 80x86 I/O functions, and to provide manual-page
 * skeletons for them as well.
 *
 * Note that on systems which already provide these functions or where they
 * cannot be provided in an inline form (such as Coherent, where they must be
 * implemented in assembly language) this module should be excluded from the
 * library builds, but should be kept for documentation extraction.
 */

/*
 *-IMPORTS:
 *	<common/ccompat.h>
 *		__USE_PROTO__
 *		__ARGS ()
 *	<sys/types.h>
 *		uchar_t
 *		ushort_t
 *		ulong_t
 */

#include <common/ccompat.h>
#include <sys/types.h>

#include <kernel/x86io.h>

#if	! defined (repinsb) || ! defined (repinsd) || ! defined (repinsw) \
		|| ! defined (repoutsb) || ! defined (repoutsd) || ! defined (repoutsw) \
		|| ! defined (inb) || ! defined (inl) || ! defined (inw) \
		|| ! defined (outb) || ! defined (outl) || ! defined (outw)
#error	This module expects preprocessor definitions for the I/O functions
#endif

/*
 *-STATUS:
 *	DDI/DKI
 *
 *-NAME:
 *	inb		Read a byte from an 8-bit I/O port
 *
 *-ARGUMENTS:
 *	port		A valid 8-bit I/O port
 *
 *-DESCRIPTION:
 *	This function provides a C-language interface to the machine
 *	instruction that reads a byte from an 8-bit I/O port using the I/O
 *	address space instead of the memory address space.
 *
 *-RETURN VALUE:
 *	Returns the value of the byte read from the I/O port.
 *
 *-LEVEL:
 *	Base or Interrupt.
 *
 *-NOTES:
 *	Does not sleep.
 *
 *	Driver-defined basic locks, read/write locks, and sleep locks may be
 *	held across calls to this function.
 *
 *	This function may not be meaningful on all implementations because
 *	some implementations may not support I/O-mapped I/O.
 */

#if	__USE_PROTO__
uchar_t (inb) (int port)
#else
uchar_t
inb __ARGS ((port))
int		port;
#endif
{
	return inb (port);
}



/*
 *-STATUS:
 *	DDI/DKI
 *
 *-NAME:
 *	inl		Read a 32-bit long word from a 32-bit I/O port
 *
 *-ARGUMENTS:
 *	port		A valid 32-bit I/O port
 *
 *-DESCRIPTION:
 *	This function provides a C-language interface to the machine
 *	instruction that reads a 32-bit long word from a 32-bit I/O port using
 *	the I/O address space instead of the memory address space.
 *
 *-RETURN VALUE:
 *	Returns the value of the 32-bit word read from the I/O port.
 *
 *-LEVEL:
 *	Base or Interrupt.
 *
 *-NOTES:
 *	Does not sleep.
 *
 *	Driver-defined basic locks, read/write locks, and sleep locks may be
 *	held across calls to this function.
 *
 *	This function may not be meaningful on all implementations because
 *	some implementations may not support I/O-mapped I/O.
 */

#if	__USE_PROTO__
ulong_t (inl) (int port)
#else
ulong_t
inl __ARGS ((port))
int		port;
#endif
{
	return inl (port);
}


/*
 *-STATUS:
 *	DDI/DKI
 *
 *-NAME:
 *	inw		Read a 16-bit short word from a 16-bit I/O port
 *
 *-ARGUMENTS:
 *	port		A valid 16-bit I/O port
 *
 *-DESCRIPTION:
 *	This function provides a C-language interface to the machine
 *	instruction that reads a 16-bit short word from a 16-bit I/O port
 *	using the I/O address space instead of the memory address space.
 *
 *-RETURN VALUE:
 *	Returns the value of the 16-bit short word read from the I/O port.
 *
 *-LEVEL:
 *	Base or Interrupt.
 *
 *-NOTES:
 *	Does not sleep.
 *
 *	Driver-defined basic locks, read/write locks, and sleep locks may be
 *	held across calls to this function.
 *
 *	This function may not be meaningful on all implementations because
 *	some implementations may not support I/O-mapped I/O.
 */

#if	__USE_PROTO__
ushort_t (inw) (int port)
#else
ushort_t
inw __ARGS ((port))
int		port;
#endif
{
	return inw (port);
}



/*
 *-STATUS:
 *	DDI/DKI
 *
 *-NAME:
 *	outb		Write a byte to an 8-bit I/O port.
 *
 *-ARGUMENTS:
 *	port		A valid 8-bit I/O port.
 *	data		The 8-bit value to the written to the port.
 *
 *-DESCRIPTION:
 *	This function provides a C-language interface to the machine
 *	instruction that writes a byte to an 8-bit I/O port using the I/O
 *	address space instead of the memory address space.
 *
 *-RETURN VALUE:
 *	None.
 *
 *-LEVEL:
 *	Base or Interrupt.
 *
 *-NOTES:
 *	Does not sleep.
 *
 *	Driver-defined basic locks, read/write locks, and sleep locks may be
 *	held across calls to this function.
 *
 *	This function may not be meaningful on all implementations because
 *	some implementations may not support I/O-mapped I/O.
 */

#if	__USE_PROTO__
void (outb) (int port, uchar_t data)
#else
void
outb __ARGS ((port, data))
int		port;
uchar_t		data;
#endif
{
	outb (port, data);
}



/*
 *-STATUS:
 *	DDI/DKI
 *
 *-NAME:
 *	outl		Write a 32-bit long word to a 32-bit I/O port.
 *
 *-ARGUMENTS:
 *	port		A valid 32-bit I/O port.
 *	data		The 32-bit value to the written to the port.
 *
 *-DESCRIPTION:
 *	This function provides a C-language interface to the machine
 *	instruction that writes a 32-bit long word to a 32-bit I/O port using
 *	the I/O address space instead of the memory address space.
 *
 *-RETURN VALUE:
 *	None.
 *
 *-LEVEL:
 *	Base or Interrupt.
 *
 *-NOTES:
 *	Does not sleep.
 *
 *	Driver-defined basic locks, read/write locks, and sleep locks may be
 *	held across calls to this function.
 *
 *	This function may not be meaningful on all implementations because
 *	some implementations may not support I/O-mapped I/O.
 */

#if	__USE_PROTO__
void (outl) (int port, ulong_t value)
#else
void
outl __ARGS ((port, value))
int		port;
ulong_t		value;
#endif
{
	outl (port, value);
}



/*
 *-STATUS:
 *	DDI/DKI
 *
 *-NAME:
 *	outw		Write a 16-bit short word to a 16-bit I/O port.
 *
 *-ARGUMENTS:
 *	port		A valid 16-bit I/O port.
 *	data		The 16-bit value to the written to the port.
 *
 *-DESCRIPTION:
 *	This function provides a C-language interface to the machine
 *	instruction that writes a 16-bit short word to a 16-bit I/O port using
 *	the I/O address space instead of the memory address space.
 *
 *-RETURN VALUE:
 *	None.
 *
 *-LEVEL:
 *	Base or Interrupt.
 *
 *-NOTES:
 *	Does not sleep.
 *
 *	Driver-defined basic locks, read/write locks, and sleep locks may be
 *	held across calls to this function.
 *
 *	This function may not be meaningful on all implementations because
 *	some implementations may not support I/O-mapped I/O.
 */

#if	__USE_PROTO__
void (outw) (int port, ushort_t value)
#else
void
outw __ARGS ((port, value))
int		port;
ushort_t	value;
#endif
{
	outw (port, value);
}


/*
 *-STATUS:
 *	DDI/DKI
 *
 *-NAME:
 *	repinsb		Read bytes from an I/O port to a buffer.
 *
 *-ARGUMENTS:
 *	port		A valid 8-bit I/O port.
 *	addr		The address of the buffer where data is stored after
 *			"cnt" reads of the I/O port.
 *	cnt		The number of bytes to be read from the I/O port.
 *
 *-DESCRIPTION:
 *	This function provides a C-language interface to the machine
 *	instructions that read a string of bytes from an 8-bit I/O port using
 *	the I/O address space instead of the memory address space. The data
 *	from "cnt" reads of the I/O port is stored in the data buffer pointed
 *	to by "addr". The data buffer should be at least "cnt" bytes in
 *	length.
 *
 *-RETURN VALUE:
 *	None.
 *
 *-LEVEL:
 *	Base or Interrupt.
 *
 *-NOTES:
 *	Does not sleep.
 *
 *	Driver-defined basic locks, read/write locks and sleep locks may be
 *	held across calls to this function.
 *
 *	This function may not be meaningful on all implementations because
 *	some implementations may not support I/O-mapped I/O.
 */

#if	__USE_PROTO__
void (repinsb) (int port, uchar_t * addr, int cnt)
#else
void
repinsb __ARGS ((port, addr, cnt))
int		port;
uchar_t	      *	addr;
int		cnt;
#endif
{
	repinsb (port, addr, cnt);
}


/*
 *-STATUS:
 *	DDI/DKI
 *
 *-NAME:
 *	repinsd		Read 32-bit long words from an I/O port to a buffer.
 *
 *-ARGUMENTS:
 *	port		A valid 32-bit I/O port.
 *	addr		The address of the buffer where data is stored after
 *			"cnt" reads of the I/O port.
 *	cnt		The number of 32-bit long words to be read from the
 *			I/O port.
 *
 *-DESCRIPTION:
 *	This function provides a C-language interface to the machine
 *	instructions that read a string of 32-bit long words from a 32-bit I/O
 *	port using the I/O address space instead of the memory address space.
 *	The data from "cnt" reads of the I/O port is stored in the data buffer
 *	pointed to by "addr". The data buffer should be at least "cnt" 32-bit
 *	long words in length.
 *
 *-RETURN VALUE:
 *	None.
 *
 *-LEVEL:
 *	Base or Interrupt.
 *
 *-NOTES:
 *	Does not sleep.
 *
 *	Driver-defined basic locks, read/write locks and sleep locks may be
 *	held across calls to this function.
 *
 *	This function may not be meaningful on all implementations because
 *	some implementations may not support I/O-mapped I/O.
 */

#if	__USE_PROTO__
void (repinsd) (int port, ulong_t * addr, int cnt)
#else
void
repinsd __ARGS ((port, addr, cnt))
int		port;
ulong_t	      *	addr;
int		cnt;
#endif
{
	repinsd (port, addr, cnt);
}


/*
 *-STATUS:
 *	DDI/DKI
 *
 *-NAME:
 *	repinsw		Read 16-bit short words from an I/O port to a buffer.
 *
 *-ARGUMENTS:
 *	port		A valid 16-bit I/O port.
 *	addr		The address of the buffer where data is stored after
 *			"cnt" reads of the I/O port.
 *	cnt		The number of 16-bit short words to be read from the
 *			I/O port.
 *
 *-DESCRIPTION:
 *	This function provides a C-language interface to the machine
 *	instructions that read a string of 16-bit short words from a 16-bit
 *	I/O port using the I/O address space instead of the memory address
 *	space. The data from "cnt" reads of the I/O port is stored in the data
 *	buffer pointed to by "addr". The data buffer should be at least "cnt"
 *	16-bit short words in length.
 *
 *-RETURN VALUE:
 *	None.
 *
 *-LEVEL:
 *	Base or Interrupt.
 *
 *-NOTES:
 *	Does not sleep.
 *
 *	Driver-defined basic locks, read/write locks and sleep locks may be
 *	held across calls to this function.
 *
 *	This function may not be meaningful on all implementations because
 *	some implementations may not support I/O-mapped I/O.
 */

#if	__USE_PROTO__
void (repinsw) (int port, ushort_t * addr, int cnt)
#else
void
repinsw __ARGS ((port, addr, cnt))
int		port;
ushort_t      *	addr;
int		cnt;
#endif
{
	repinsw (port, addr, cnt);
}


/*
 *-STATUS:
 *	DDI/DKI
 *
 *-NAME:
 *	repoutsb	Write bytes from a buffer to an I/O port.
 *
 *-ARGUMENTS:
 *	port		A valid 8-bit I/O port.
 *	addr		The address of the buffer from which "cnt" bytes are
 *			written to the I/O port.
 *	cnt		The number of bytes to be written to the I/O port.
 *
 *-DESCRIPTION:
 *	This function provides a C-language interface to the machine
 *	instructions that write a string of bytes to an 8-bit I/O port using
 *	the I/O address space instead of the memory address space. "cnt"
 *	bytes starting at the address pointed to by "addr" are written to the
 *	I/O port in "cnt" write operations. The buffer should be at least
 *	"cnt" bytes in length.
 *
 *-RETURN VALUE:
 *	None.
 *
 *-LEVEL:
 *	Base or Interrupt.
 *
 *-NOTES:
 *	Does not sleep.
 *
 *	Driver-defined basic locks, read/write locks and sleep locks may be
 *	held across calls to this function.
 *
 *	This function may not be meaningful on all implementations because
 *	some implementations may not support I/O-mapped I/O.
 */

#if	__USE_PROTO__
void (repoutsb) (int port, uchar_t * addr, int cnt)
#else
void
repoutsb __ARGS ((port, addr, cnt))
int		port;
uchar_t	      *	addr;
int		cnt;
#endif
{
	repoutsb (port, addr, cnt);
}


/*
 *-STATUS:
 *	DDI/DKI
 *
 *-NAME:
 *	repoutsd	Write 32-bit long words from a buffer to an I/O port.
 *
 *-ARGUMENTS:
 *	port		A valid 32-bit I/O port.
 *	addr		The address of the buffer from which "cnt" 32-bit long
 *			words are written to the I/O port.
 *	cnt		The number of 32-bit long words to be written to the
 *			I/O port.
 *
 *-DESCRIPTION:
 *	This function provides a C-language interface to the machine
 *	instructions that write a string of 32-bit long words to a 32-bit I/O
 *	port using the I/O address space instead of the memory address space.
 *	"cnt" 32-bit long words starting at the address pointed to by "addr"
 *	are written to the I/O port in "cnt" write operations. The buffer
 *	should be at least "cnt" 32-bit long words in length.
 *
 *-RETURN VALUE:
 *	None.
 *
 *-LEVEL:
 *	Base or Interrupt.
 *
 *-NOTES:
 *	Does not sleep.
 *
 *	Driver-defined basic locks, read/write locks and sleep locks may be
 *	held across calls to this function.
 *
 *	This function may not be meaningful on all implementations because
 *	some implementations may not support I/O-mapped I/O.
 */

#if	__USE_PROTO__
void (repoutsd) (int port, ulong_t * addr, int cnt)
#else
void
repoutsd __ARGS ((port, addr, cnt))
int		port;
ulong_t	      *	addr;
int		cnt;
#endif
{
	repoutsd (port, addr, cnt);
}


/*
 *-STATUS:
 *	DDI/DKI
 *
 *-NAME:
 *	repoutsw	Write 16-bit short words from a buffer to an I/O port.
 *
 *-ARGUMENTS:
 *	port		A valid 32-bit I/O port.
 *	addr		The address of the buffer from which "cnt" 16-bit
			short words are written to the I/O port.
 *	cnt		The number of 16-bit short words to be written to the
 *			I/O port.
 *
 *-DESCRIPTION:
 *	This function provides a C-language interface to the machine
 *	instructions that write a string of 16-bit short words to a 16-bit I/O
 *	port using the I/O address space instead of the memory address space.
 *	"cnt" 16-bit short words starting at the address pointed to by "addr"
 *	are written to the I/O port in "cnt" write operations. The buffer
 *	should be at least "cnt" 16-bit short words in length.
 *
 *-RETURN VALUE:
 *	None.
 *
 *-LEVEL:
 *	Base or Interrupt.
 *
 *-NOTES:
 *	Does not sleep.
 *
 *	Driver-defined basic locks, read/write locks and sleep locks may be
 *	held across calls to this function.
 *
 *	This function may not be meaningful on all implementations because
 *	some implementations may not support I/O-mapped I/O.
 */

#if	__USE_PROTO__
void (repoutsw) (int port, ushort_t * addr, int cnt)
#else
void
repoutsw __ARGS ((port, addr, cnt))
int		port;
ushort_t      *	addr;
int		cnt;
#endif
{
	repoutsw (port, addr, cnt);
}
