//////////
/ n1/i386/tables/amul.t
//////////

/////////
/
/ Assigned multiplication (*=).
/ Immediate byte operands use the three-operand multiply immediate form.
/ Otherwise, the multiply is done in EDX:EAX.
/ [TL ZIMUL] is ZIMUL if signed, ZMUL if unsigned; cf. n1/i386/outmch.c.
/ Signed multiply should use the i386 two-operand MUL but currently does not.
/
/////////

AMUL:

//////////
/ Long.
//////////

/ Long *= byte constant.
%	PEFFECT|PVALUE
	LONG		ANYR	*	*	TEMP
		ADR|LV		LONG
		SBYTE|MMX	LONG
			[ZIMULI]	[R],[AL],[AR]
			[ZMOV]		[AL],[R]

/ Long *= long.
%	PEFFECT|PVALUE
	LONG		EDXEAX	*	*	EAX
		ADR|LV		LONG
		ADR		LONG
			[ZMOV]		[REGNO EAX],[AL]
			[TL ZIMUL]	[AR]
			[ZMOV]		[AL],[REGNO EAX]

//////////
/ Short.
/ Sign- or zero-extend the result in value context.
//////////

/ Short *= long.
%	PEFFECT|PVALUE
	LONG		EDXEAX	*	*	EAX
		ADR|LV		WORD|BYTE
		ADR		LONG
			[TL ZMOVSX]	[REGNO EAX],[AL]
			[TL ZIMUL]	[AR]
			[TL ZMOV]	[AL],[TL REGNO EAX]
		[IFV]	[TL ZMOVSX]	[REGNO EAX],[TL REGNO EAX]

//////////
/ Fields.
//////////

/ Field.
%	PEFFECT|PVALUE
	LONG		EDXEAX	*	*	EAX
		ADR|LV		FLD
		ADR		LONG
			[TL ZMOVZX]	[REGNO EAX],[AL]	/ fetch
			[ZAND]		[REGNO EAX],[EMASK]	/ extract
			[ZMUL]		[AR]			/ multiply
			[ZAND]		[REGNO EAX],[EMASK]	/ mask
			[TL ZAND]	[AL],[TL CMASK]		/ clear
			[TL ZOR]	[AL],[TL REGNO EAX]	/ store

//////////
/ Floating point.
//////////

/ IEEE or DECVAX software floating point.
/ Double *= double.
%	PEFFECT|PVALUE|P_SRT|PDECVAX|PIEEE
	FF64		EDXEAX	*	EDXEAX	TEMP
		ADR|LV		FF64
		TREG		FF64
			[ZPUSH]	[HI AL]
			[ZPUSH]	[LO AL]
			[ZCALL]	[GID _dmul]
			[ZADD]	[REGNO ESP],[CONST 8]
			[ZMOV]	[HI AL],[HI R]
			[ZMOV]	[LO AL],[LO R]

/ Float *= double.
%	PEFFECT|PVALUE|P_SRT|PDECVAX|PIEEE
	FF64		EDXEAX	*	EDXEAX	TEMP
		ADR|LV		FF32
		TREG		FF64
			[ZPUSH]	[AL]
			[ZCALL]	[GID _fmul]
			[ZADD]	[REGNO ESP],[CONST 4]
			[ZCALL]	[GID _fdcvt]
			[ZMOV]	[AL], [LO R]
		[IFV]	[ZCALL]	[GID _dfcvt]

/ Hardware coprocessor (NDP) floating point.
%	PEFFECT|PVALUE|PNDP
	FLOAT		FPAC	*	FPAC	FPAC
		ADR|LV		FLOAT
		TREG		FF64
			[TL ZFMULD]	[AL]
		[IFV]	[TL ZFSTD]	[AL]
		[IFE]	[TL ZFSTPD]	[AL]

//////////
/ end of n1/i386/tables/amul.t
//////////
