/*
 * getopt - get option letter from argv
 */

#include <stdio.h>

char	*optarg;	/* Global argument pointer. */
int	optind = 1;	/* Global argv index. */

static char	*scan = NULL;	/* Private scan pointer. */

extern char	*strchr();

int
getopt(argc, argv, optstring)
int argc;
char *argv[];
char *optstring;
{
	register char c;
	register char *place;

	for (optarg = NULL; scan == NULL || !*scan; scan++, optind++) {
		if ((optind >= argc) || (*(scan = argv[optind]) != '-')) {
			scan = NULL;
			return(EOF);
		}
	}

	if ((place = strchr(optstring, c = *scan++)) == NULL || c == ':') {
		fprintf(stderr, "%s: unknown option %c\n", argv[0], c);
		return('?');
	}

	if (place[1] == ':') {
		if (*scan) {
			optarg = scan;
			scan = NULL;
		} else if (optind < argc)
			optarg = argv[optind++];
		else {
			fprintf(stderr, "%s: %c argument missing\n", argv[0], c);
			return('?');
		}
	}

	return(c);
}

#ifdef TEST
/*
 * This test example shows how to use getopt in a program.
 * Typical test lines are
 * getopt -xyfxxx -f yyy a b c
 * getopt -xj
 */
main(argc, argv)
char *argv[];
{
	char c;

	while(EOF != (c = getopt(argc, argv, "xyf:")))
		switch(c) {
		case 'x':
			printf("option x\n");
			break;
		case 'y':
			printf("option y\n");
			break;
		case 'f':
			printf("option f with %s\n", optarg);
			break;
		default:
			printf("usage: getopt [-xy] [-f filen]\n");
			exit(1);
		}
	for(;optind < argc; optind++)
		printf("Trailing %s\n", argv[optind]);
	exit(0);
}
#endif
