/*
 * libm/cos.c
 * Evaluate the cosine function.
 */

#include <math.h>

#if	EMU87
#include "emumath.h"
#endif

/*
 * (Hart 2923, 19.96)
 */
static readonly double sintab[] ={
	 0.523598775598298873071308e+00,
	-0.239245962039350458667960e-01,
	 0.327953194428661969081000e-03,
	-0.214071976918198811800000e-05,
	 0.815125650404748400000000e-08,
	-0.203153509377510000000000e-10,
	 0.355397103280000000000000e-13
};

/*
 * (Hart 3824, 19.45)
 */
static readonly double costab[] ={
	 0.99999999999999999996415,
	-0.30842513753404245242414,
	 0.01585434424381541089754,
	-0.00032599188692668755044,
	 0.00000359086044588581953,
	-0.00000002461136382637005,
	 0.00000000011500497024263,
	-0.00000000000038577620372
};

double
cos(x) double x;
{
	double r;
	register int s;

	if ((x = modf(x/(2.0*PI), &r)) < 0.0) {
		x += 1.0;
		r -= 1.0;
	}
	s = 0;
	if (x > 0.5) {
		s = 1;
		x -= 0.5;
	}
	if (x > 0.25) {
		s ^= 1;
		x = 0.5 - x;
	}
	if (x > 0.125) {
		x = 3.0 - 12.0*x;
		r = x*_pol(x*x, sintab, 7);
	} else {
		x *= 8.0;
		r = _pol(x*x, costab, 8);
	}
	return s ? -r : r;
}

/* end of libm/cos.c */
