/*
**	term.h -- Definition of struct term
*/

#ifndef SGTTY
#    include "curses.h"
#endif

#ifdef SINGLE
#	define CUR _first_term.
#else
#	define CUR cur_term->
#endif


#define auto_left_margin               CUR Booleans[0]
#define auto_right_margin              CUR Booleans[1]
#define beehive_glitch                 CUR Booleans[2]
#define ceol_standout_glitch           CUR Booleans[3]
#define eat_newline_glitch             CUR Booleans[4]
#define erase_overstrike               CUR Booleans[5]
#define generic_type                   CUR Booleans[6]
#define hard_copy                      CUR Booleans[7]
#define has_meta_key                   CUR Booleans[8]
#define has_status_line                CUR Booleans[9]
#define insert_null_glitch             CUR Booleans[10]
#define memory_above                   CUR Booleans[11]
#define memory_below                   CUR Booleans[12]
#define move_insert_mode               CUR Booleans[13]
#define move_standout_mode             CUR Booleans[14]
#define over_strike                    CUR Booleans[15]
#define status_line_esc_ok             CUR Booleans[16]
#define teleray_glitch                 CUR Booleans[17]
#define tilde_glitch                   CUR Booleans[18]
#define transparent_underline          CUR Booleans[19]
#define xon_xoff                       CUR Booleans[20]
#define columns                        CUR Numbers[0]
#define init_tabs                      CUR Numbers[1]
#define lines                          CUR Numbers[2]
#define lines_of_memory                CUR Numbers[3]
#define magic_cookie_glitch            CUR Numbers[4]
#define padding_baud_rate              CUR Numbers[5]
#define virtual_terminal               CUR Numbers[6]
#define width_status_line              CUR Numbers[7]
#define num_labels                     CUR Numbers[8]
#define label_height                   CUR Numbers[9]
#define label_width                    CUR Numbers[10]
#define back_tab                       CUR Strings[0]
#define bell                           CUR Strings[1]
#define carriage_return                CUR Strings[2]
#define change_scroll_region           CUR Strings[3]
#define clear_all_tabs                 CUR Strings[4]
#define clear_screen                   CUR Strings[5]
#define clr_eol                        CUR Strings[6]
#define clr_eos                        CUR Strings[7]
#define column_address                 CUR Strings[8]
#define command_character              CUR Strings[9]
#define cursor_address                 CUR Strings[10]
#define cursor_down                    CUR Strings[11]
#define cursor_home                    CUR Strings[12]
#define cursor_invisible               CUR Strings[13]
#define cursor_left                    CUR Strings[14]
#define cursor_mem_address             CUR Strings[15]
#define cursor_normal                  CUR Strings[16]
#define cursor_right                   CUR Strings[17]
#define cursor_to_ll                   CUR Strings[18]
#define cursor_up                      CUR Strings[19]
#define cursor_visible                 CUR Strings[20]
#define delete_character               CUR Strings[21]
#define delete_line                    CUR Strings[22]
#define dis_status_line                CUR Strings[23]
#define down_half_line                 CUR Strings[24]
#define enter_alt_charset_mode         CUR Strings[25]
#define enter_blink_mode               CUR Strings[26]
#define enter_bold_mode                CUR Strings[27]
#define enter_ca_mode                  CUR Strings[28]
#define enter_delete_mode              CUR Strings[29]
#define enter_dim_mode                 CUR Strings[30]
#define enter_insert_mode              CUR Strings[31]
#define enter_secure_mode              CUR Strings[32]
#define enter_protected_mode           CUR Strings[33]
#define enter_reverse_mode             CUR Strings[34]
#define enter_standout_mode            CUR Strings[35]
#define enter_underline_mode           CUR Strings[36]
#define erase_chars                    CUR Strings[37]
#define exit_alt_charset_mode          CUR Strings[38]
#define exit_attribute_mode            CUR Strings[39]
#define exit_ca_mode                   CUR Strings[40]
#define exit_delete_mode               CUR Strings[41]
#define exit_insert_mode               CUR Strings[42]
#define exit_standout_mode             CUR Strings[43]
#define exit_underline_mode            CUR Strings[44]
#define flash_screen                   CUR Strings[45]
#define form_feed                      CUR Strings[46]
#define from_status_line               CUR Strings[47]
#define init_1string                   CUR Strings[48]
#define init_2string                   CUR Strings[49]
#define init_3string                   CUR Strings[50]
#define init_file                      CUR Strings[51]
#define insert_character               CUR Strings[52]
#define insert_line                    CUR Strings[53]
#define insert_padding                 CUR Strings[54]
#define key_backspace                  CUR Strings[55]
#define key_catab                      CUR Strings[56]
#define key_clear                      CUR Strings[57]
#define key_ctab                       CUR Strings[58]
#define key_dc                         CUR Strings[59]
#define key_dl                         CUR Strings[60]
#define key_down                       CUR Strings[61]
#define key_eic                        CUR Strings[62]
#define key_eol                        CUR Strings[63]
#define key_eos                        CUR Strings[64]
#define key_f0                         CUR Strings[65]
#define key_f1                         CUR Strings[66]
#define key_f10                        CUR Strings[67]
#define key_f2                         CUR Strings[68]
#define key_f3                         CUR Strings[69]
#define key_f4                         CUR Strings[70]
#define key_f5                         CUR Strings[71]
#define key_f6                         CUR Strings[72]
#define key_f7                         CUR Strings[73]
#define key_f8                         CUR Strings[74]
#define key_f9                         CUR Strings[75]
#define key_home                       CUR Strings[76]
#define key_ic                         CUR Strings[77]
#define key_il                         CUR Strings[78]
#define key_left                       CUR Strings[79]
#define key_ll                         CUR Strings[80]
#define key_npage                      CUR Strings[81]
#define key_ppage                      CUR Strings[82]
#define key_right                      CUR Strings[83]
#define key_sf                         CUR Strings[84]
#define key_sr                         CUR Strings[85]
#define key_stab                       CUR Strings[86]
#define key_up                         CUR Strings[87]
#define keypad_local                   CUR Strings[88]
#define keypad_xmit                    CUR Strings[89]
#define lab_f0                         CUR Strings[90]
#define lab_f1                         CUR Strings[91]
#define lab_f10                        CUR Strings[92]
#define lab_f2                         CUR Strings[93]
#define lab_f3                         CUR Strings[94]
#define lab_f4                         CUR Strings[95]
#define lab_f5                         CUR Strings[96]
#define lab_f6                         CUR Strings[97]
#define lab_f7                         CUR Strings[98]
#define lab_f8                         CUR Strings[99]
#define lab_f9                         CUR Strings[100]
#define meta_off                       CUR Strings[101]
#define meta_on                        CUR Strings[102]
#define newline                        CUR Strings[103]
#define pad_char                       CUR Strings[104]
#define parm_dch                       CUR Strings[105]
#define parm_delete_line               CUR Strings[106]
#define parm_down_cursor               CUR Strings[107]
#define parm_ich                       CUR Strings[108]
#define parm_index                     CUR Strings[109]
#define parm_insert_line               CUR Strings[110]
#define parm_left_cursor               CUR Strings[111]
#define parm_right_cursor              CUR Strings[112]
#define parm_rindex                    CUR Strings[113]
#define parm_up_cursor                 CUR Strings[114]
#define pkey_key                       CUR Strings[115]
#define pkey_local                     CUR Strings[116]
#define pkey_xmit                      CUR Strings[117]
#define print_screen                   CUR Strings[118]
#define prtr_off                       CUR Strings[119]
#define prtr_on                        CUR Strings[120]
#define repeat_char                    CUR Strings[121]
#define reset_1string                  CUR Strings[122]
#define reset_2string                  CUR Strings[123]
#define reset_3string                  CUR Strings[124]
#define reset_file                     CUR Strings[125]
#define restore_cursor                 CUR Strings[126]
#define row_address                    CUR Strings[127]
#define save_cursor                    CUR Strings[128]
#define scroll_forward                 CUR Strings[129]
#define scroll_reverse                 CUR Strings[130]
#define set_attributes                 CUR Strings[131]
#define set_tab                        CUR Strings[132]
#define set_window                     CUR Strings[133]
#define tab                            CUR Strings[134]
#define to_status_line                 CUR Strings[135]
#define underline_char                 CUR Strings[136]
#define up_half_line                   CUR Strings[137]
#define init_prog                      CUR Strings[138]
#define key_a1                         CUR Strings[139]
#define key_a3                         CUR Strings[140]
#define key_b2                         CUR Strings[141]
#define key_c1                         CUR Strings[142]
#define key_c3                         CUR Strings[143]
#define prtr_non                       CUR Strings[144]
#define char_padding                   CUR Strings[145]
#define acs_chars                      CUR Strings[146]
#define plab_norm                      CUR Strings[147]


struct term
{
   char	 *term_names;	/* offset in str_table of terminal names */
   char	 *str_table;	/* pointer to string table */
   short Filedes;	/* file description being written to */
   SGTTY Ottyb,		/* original state of the terminal */
	 Nttyb;		/* current state of the terminal */

   char		 Booleans[21];
   short	 Numbers[11];
   char		 *Strings[148];
};

struct term	_first_term;
struct term	*cur_term;

#define BOOLCOUNT 21
#define NUMCOUNT  11
#define STRCOUNT  148
